/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb_annox.plugin.removeannotation;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.hyperjaxb_annox.plugin.AnnotationTarget;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class RemoveAnnotationPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XremoveAnnotation";
    private static final String OPTION_DESC = "remove specific, targeted annotation(s)";
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final QName REMOVE_ANNOTATION_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotation");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromProperty");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_GETTER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertyGetter");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertySetter");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_FIELD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertyField");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_PARAMETER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertySetterParameter");
    public static final QName REMOVE_ANNOTATION_FROM_PACKAGE_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPackage");
    public static final QName REMOVE_ANNOTATION_FROM_CLASS_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromClass");
    public static final QName REMOVE_ANNOTATION_FROM_ELEMENT_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromElement");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnum");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_CONSTANT_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnumConstant");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_VALUE_METHOD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnumValueMethod");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_FROM_VALUE_METHOD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnumFromValueMethod");
    public static final Set<QName> CUSTOMIZATION_ELEMENT_QNAMES = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(REMOVE_ANNOTATION_QNAME, REMOVE_ANNOTATION_FROM_PACKAGE_QNAME, REMOVE_ANNOTATION_FROM_CLASS_QNAME, REMOVE_ANNOTATION_FROM_ELEMENT_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_FIELD_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_GETTER_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_PARAMETER_QNAME, REMOVE_ANNOTATION_FROM_ENUM_QNAME, REMOVE_ANNOTATION_FROM_ENUM_CONSTANT_QNAME, REMOVE_ANNOTATION_FROM_ENUM_VALUE_METHOD_QNAME, REMOVE_ANNOTATION_FROM_ENUM_FROM_VALUE_METHOD_QNAME)));
    private String defaultFieldTarget = "getter";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Collection<QName> getCustomizationElementNames() {
        return CUSTOMIZATION_ELEMENT_QNAMES;
    }

    private boolean isCustomizationElementName(QName name) {
        return CUSTOMIZATION_ELEMENT_QNAMES.contains(name);
    }

    public String getDefaultFieldTarget() {
        return this.defaultFieldTarget;
    }

    public void setDefaultFieldTarget(String defaultFieldTarget) {
        if (!("getter".equals(defaultFieldTarget) || "setter".equals(defaultFieldTarget) || "setter-parameter".equals(defaultFieldTarget) || "field".equals(defaultFieldTarget))) {
            throw new IllegalArgumentException("Invalid default field target.");
        }
        this.defaultFieldTarget = defaultFieldTarget;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  DefaultFieldTarget.: " + this.getDefaultFieldTarget());
            sb.append("\n  Verbose............: " + this.isVerbose());
            sb.append("\n  Debug..............: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processElementOutline(ElementOutline elementOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ElementOutline)elementOutline);
        this.removeAnnotationFromElementOutline(elementOutline, customizations);
    }

    protected void removeAnnotationFromElementOutline(ElementOutline elementOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass theElementClass = elementOutline.implClass;
        JCodeModel theElementOwner = theElementClass.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ELEMENT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(elementOutline.parent(), elementOutline);
                if (!this.removeAnnotation(theElementOwner, customization, element, annotatable)) continue;
                this.debug("{}, removeAnnotationFromElementOutline; Class={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (ElementOutline)elementOutline), theElementClass.name()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processClassOutline(ClassOutline classOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ClassOutline)classOutline);
        this.removeAnnotationFromClassOutline(classOutline, customizations);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.processFieldOutline(classOutline, fieldOutline);
        }
    }

    protected void removeAnnotationFromClassOutline(ClassOutline classOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass theClassRef = classOutline.ref;
        JCodeModel theClassRefOwner = theClassRef.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.CLASS);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(classOutline.parent(), classOutline);
                if (!this.removeAnnotation(theClassRefOwner, customization, element, annotatable)) continue;
                this.debug("{}, removeAnnotationFromClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (ClassOutline)classOutline), theClassRef.name()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processFieldOutline(ClassOutline classOutline, FieldOutline fieldOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((FieldOutline)fieldOutline);
        this.removeAnnotationFromFieldOutline(fieldOutline, customizations);
    }

    protected void removeAnnotationFromFieldOutline(FieldOutline fieldOutline, CCustomizations customizations) throws SAXParseException {
        CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
        JDefinedClass fieldParentRef = fieldOutline.parent().ref;
        JCodeModel fieldParentRefOwner = fieldParentRef.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.getAnnotationTarget(this.getDefaultFieldTarget()));
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(fieldOutline.parent().parent(), fieldOutline);
                if (!this.removeAnnotation(fieldParentRefOwner, customization, element, annotatable)) continue;
                this.trace("{}, removeAnnotationFromFieldOutline; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (FieldOutline)fieldOutline), fieldParentRef.name(), fieldInfo.getName(false)});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error removing the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processEnumOutline(EnumOutline enumOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumOutline)enumOutline);
        this.removeAnnotationFromEnumOutline(enumOutline, customizations);
        for (EnumConstantOutline enumConstantOutline : enumOutline.constants) {
            this.processEnumConstantOutline(enumOutline, enumConstantOutline);
        }
    }

    protected void removeAnnotationFromEnumOutline(EnumOutline enumOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass theEnumClass = enumOutline.clazz;
        JCodeModel theEnumClassOwner = theEnumClass.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(enumOutline.parent(), enumOutline);
                if (!this.removeAnnotation(theEnumClassOwner, customization, element, annotatable)) continue;
                this.debug("{}, removeAnnotationFromEnumOutline; Enum={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (EnumOutline)enumOutline), theEnumClass.name()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumConstantOutline)enumConstantOutline);
        this.removeAnnotationFromEnumConstantOutline(enumOutline, enumConstantOutline, customizations);
    }

    protected void removeAnnotationFromEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass enumClass = enumOutline.clazz;
        Outline enumOutlineParent = enumOutline.parent();
        JCodeModel enumOutlineParentOwner = enumOutlineParent.getCodeModel();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM_CONSTANT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(enumOutlineParent, enumConstantOutline);
                if (!this.removeAnnotation(enumOutlineParentOwner, customization, element, annotatable)) continue;
                this.trace("{}, removeAnnotationFromEnumConstantOutline; Class={}, EnumConstant={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (EnumOutline)enumOutline), enumClass.name(), enumConstantOutline.constRef.getName()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    private boolean removeAnnotation(JCodeModel codeModel, CPluginCustomization customization, Element element, JAnnotatable annotatable) throws SAXParseException {
        boolean removed = false;
        String aClass = element.getAttribute(CLASS_ATTRIBUTE_NAME);
        if (StringUtils.isBlank((CharSequence)aClass)) {
            StringBuilder msg = new StringBuilder();
            msg.append("Could not remove the annotation, annotation class is not specified. ");
            msg.append("Annotation class must be specified using the class attribute of the customization element.");
            throw new SAXParseException(msg.toString(), customization.locator);
        }
        JClass annotationClass = codeModel.ref(aClass);
        JAnnotationUse annotationUse = null;
        for (JAnnotationUse annotation : annotatable.annotations()) {
            if (!annotationClass.equals(annotation.getAnnotationClass())) continue;
            annotationUse = annotation;
        }
        if (annotationUse == null) {
            String msg = String.format("Could not remove the annotation, target element is not annotated with annotation class [%s].", annotationClass);
            throw new SAXParseException(msg, customization.locator);
        }
        removed = annotatable.removeAnnotation(annotationUse);
        return removed;
    }
}

