/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.dbc;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import patterntesting.runtime.dbc.DbC;
import patterntesting.runtime.util.Assertions;

@Aspect
public class CollectionsAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ CollectionsAspect ajc$perSingletonInstance;

    static {
        try {
            CollectionsAspect.ajc$perSingletonInstance = new CollectionsAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Before(value="(call(int java.util.Collections.binarySearch(List, Object)) && (!within(Collections) && args(l, *)))", argNames="l")
    public void ajc$before$patterntesting_runtime_dbc_CollectionsAspect$1$449a6448(List l) {
        if (Assertions.ENABLED) {
            DbC.require(CollectionsAspect.isSorted(l), "list is unsorted");
        }
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Before(value="(call(int java.util.Collections.binarySearch(List, Object, Comparator)) && (!within(Collections) && args(l, *, c)))", argNames="l,c")
    public void ajc$before$patterntesting_runtime_dbc_CollectionsAspect$2$a9c8b785(List l, Comparator c) {
        if (Assertions.ENABLED) {
            DbC.require(CollectionsAspect.isSorted(l, c), "list is unsorted");
        }
    }

    public static <T> boolean isSorted(List<? extends Comparable<? super T>> list) {
        if (list.isEmpty()) {
            return true;
        }
        Iterator<Comparable<T>> iterator = list.iterator();
        Comparable<Comparable<? super T>> prev = iterator.next();
        while (iterator.hasNext()) {
            Comparable<? super T> next = iterator.next();
            if (prev.compareTo(next) > 0) {
                return false;
            }
            prev = next;
        }
        return true;
    }

    public static <T> boolean isSorted(List<? extends T> list, Comparator<? super T> c) {
        if (list.isEmpty()) {
            return true;
        }
        Iterator<T> iterator = list.iterator();
        T prev = iterator.next();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (c.compare(prev, next) > 0) {
                return false;
            }
            prev = next;
        }
        return true;
    }

    public static CollectionsAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("patterntesting_runtime_dbc_CollectionsAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

