/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.dbc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.dbc.ContractAspect;
import patterntesting.runtime.dbc.ContractViolation;
import patterntesting.runtime.util.Assertions;

public final class DbC {
    private static final Logger LOG = LoggerFactory.getLogger(DbC.class);

    static {
        if (Assertions.ENABLED) {
            LOG.debug("DbC is active");
        } else {
            LOG.debug("DbC deactivated - call 'java -ea' (SunVM) to activate it");
        }
    }

    private DbC() {
    }

    public static void require(boolean precondition) {
        ContractAspect.ajc$cflowCounter$0.inc();
        try {
            DbC.require(precondition, "precondition violated");
        }
        finally {
            ContractAspect.ajc$cflowCounter$0.dec();
        }
    }

    public static void require(boolean precondition, Object message) {
        ContractAspect.ajc$cflowCounter$0.inc();
        try {
            if (Assertions.ENABLED && !precondition) {
                throw new ContractViolation(message);
            }
        }
        finally {
            ContractAspect.ajc$cflowCounter$0.dec();
        }
    }

    public static void ensure(boolean postcondition) {
        ContractAspect.ajc$cflowCounter$0.inc();
        try {
            DbC.ensure(postcondition, "postcondition violated");
        }
        finally {
            ContractAspect.ajc$cflowCounter$0.dec();
        }
    }

    public static void ensure(boolean postcondition, Object message) {
        ContractAspect.ajc$cflowCounter$0.inc();
        try {
            if (Assertions.ENABLED && !postcondition) {
                throw new ContractViolation(message);
            }
        }
        finally {
            ContractAspect.ajc$cflowCounter$0.dec();
        }
    }
}

