/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.io;

import clazzfish.monitor.ClasspathMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.exception.DetailedInvalidClassException;
import patterntesting.runtime.io.BinarySerializer;
import patterntesting.runtime.io.XStreamSerializer;

public abstract class AbstractSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSerializer.class);
    private static final AbstractSerializer instance = AbstractSerializer.isXStreamAvailable() ? new XStreamSerializer() : new BinarySerializer();

    private static boolean isXStreamAvailable() {
        String xstreamClassname = "com.thoughtworks.xstream.XStream";
        URI xstreamURI = ClasspathMonitor.getInstance().whichClass(xstreamClassname);
        if (xstreamURI == null) {
            LOG.debug("{} not found in classpath for serialization.", (Object)xstreamClassname);
            return false;
        }
        LOG.debug("{} found in {} for serialization.", (Object)xstreamClassname, (Object)xstreamURI);
        return true;
    }

    public static AbstractSerializer getInstance() {
        return instance;
    }

    public abstract ObjectInputStream createObjectInputStream(InputStream var1) throws IOException;

    public abstract ObjectOutputStream createObjectOutputStream(OutputStream var1) throws IOException;

    public Object load(File file) throws IOException {
        try (FileInputStream istream = new FileInputStream(file);){
            Object object = this.load(istream);
            return object;
        }
    }

    public Object load(InputStream in) throws IOException {
        ObjectInputStream objStream = this.createObjectInputStream(in);
        try {
            return objStream.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new DetailedInvalidClassException("cannot load from " + in, ex);
        }
    }

    public void save(Object object, File file) throws IOException {
        try (FileOutputStream ostream = new FileOutputStream(file);){
            this.save(object, ostream);
            ostream.flush();
        }
    }

    public void save(Object object, OutputStream out) throws IOException {
        ObjectOutputStream objStream = this.createObjectOutputStream(out);
        objStream.writeObject(object);
        objStream.flush();
    }
}

