/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.io.BetterFileOutputStream;
import patterntesting.runtime.util.Converter;

public final class ExtendedFile
extends File {
    private static final long serialVersionUID = 20140827L;
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedFile.class);

    public ExtendedFile(File file) {
        super(file.getPath());
    }

    public ExtendedFile(String filename) {
        super(filename);
    }

    public ExtendedFile(File parent, String filename) {
        super(parent, filename);
    }

    public ExtendedFile(String parent, String filename) {
        super(parent, filename);
    }

    public ExtendedFile(URI fileURI) {
        super(fileURI);
    }

    public ExtendedFile(File parent, File file) {
        super(parent, file.getPath());
    }

    public static void validate(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(ExtendedFile.getMessageForMissing(file));
        }
    }

    private static String getMessageForMissing(File file) {
        String msg = "file '" + file + "' does not exist";
        File similar = ExtendedFile.findSimilarFile(file);
        if (!similar.getPath().equals(file.getPath())) {
            msg = String.valueOf(msg) + " - do you mean '" + similar + "'?";
        }
        return msg;
    }

    private static File findSimilarFile(File file) {
        File dir = file.getParentFile();
        if (dir == null) {
            File currentDir = new File(".");
            return new File(ExtendedFile.findSimilarFilename(currentDir, file.getName()));
        }
        File similarDir = ExtendedFile.findSimilarFile(dir);
        String similarFilename = ExtendedFile.findSimilarFilename(similarDir, file.getName());
        return new File(similarDir, similarFilename);
    }

    private static String findSimilarFilename(File currentDir, String filename) {
        String[] currentFiles = currentDir.list();
        if (currentFiles != null) {
            String[] stringArray = currentFiles;
            int n = currentFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (filename.equalsIgnoreCase(name)) {
                    LOG.debug("Similar file '{}' for missing '{}' found.", (Object)name, (Object)filename);
                    return name;
                }
                ++n2;
            }
        }
        LOG.trace("No similar '{}' found.", (Object)filename);
        return filename;
    }

    public static File createTmpdir(String prefix, String suffix) throws IOException {
        long n = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ExtendedFile.currentTimeMillis_aroundBody1$advice(TimeMachineAspect.aspectOf(), null) : ExtendedFile.currentTimeMillis_aroundBody0();
        File tmpdir = ExtendedFile.getTmpdir(String.valueOf(prefix) + "@" + Long.toString(n, 36) + suffix);
        if (tmpdir.exists()) {
            LOG.debug("{} exists already, will increase timestamp.", (Object)tmpdir);
            tmpdir = ExtendedFile.getTmpdir(String.valueOf(prefix) + "@" + Long.toString(n + 1L, 36) + suffix);
        }
        if (!tmpdir.mkdirs()) {
            throw new IOException("can't create dir " + tmpdir);
        }
        LOG.trace("Dir {} is created.", (Object)tmpdir);
        return tmpdir;
    }

    public static File getTmpdir(String filename) {
        File tmpdir = FileUtils.getTempDirectory();
        return new File(tmpdir, filename);
    }

    public static String[] toStringArray(List<File> files) {
        String[] array = new String[files.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = files.get(i).getPath();
            ++i;
        }
        return array;
    }

    public ExtendedFile getParentExtendedFile() {
        return new ExtendedFile(this.getParentFile());
    }

    public File normalize() {
        return ExtendedFile.normalize(this);
    }

    public static File normalize(File file) {
        String filename = file.getAbsolutePath();
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException ex) {
            LOG.debug("Cannot get " + file + " as cannocial path:", (Throwable)ex);
        }
        filename = FilenameUtils.normalize((String)filename);
        return new File(filename);
    }

    public boolean endsWith(File extension) {
        assert (!extension.isAbsolute()) : "not relative: " + extension;
        String extensionName = FilenameUtils.normalize((String)extension.getPath());
        String filename = FilenameUtils.normalize((String)this.getAbsolutePath());
        return filename.endsWith(extensionName);
    }

    public File getBaseDir(File extension) {
        assert (!extension.isAbsolute()) : "not relative: " + extension;
        if (extension.getName().equals(this.getName())) {
            File extensionParent = extension.getParentFile();
            if (extensionParent == null) {
                return this.getParentExtendedFile();
            }
            return this.getParentExtendedFile().getBaseDir(extensionParent);
        }
        LOG.debug("Base dir is '{}' because '{}' does not end with '{}'.", new Object[]{this, extension, this.getName()});
        return this;
    }

    public static OutputStream createOutputStreamFor(File file) {
        if (file.exists()) {
            if (file.delete()) {
                LOG.info("Old file \"{}\" was deleted.", (Object)file);
            } else {
                LOG.warn("Old log file \"{}\" could not be deleted!", (Object)file);
            }
        }
        try {
            return new BetterFileOutputStream(file, true);
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug("Cannot log to {}:", (Object)file, (Object)fnfe);
            LOG.info("Will log to stdout because cannot log to \"{}\" ({}).", (Object)file, (Object)fnfe.getMessage());
            return System.out;
        }
    }

    public OutputStream createOutputStream() {
        return ExtendedFile.createOutputStreamFor(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        File otherFile = ExtendedFile.normalize((File)obj);
        File thisFile = this.normalize();
        return thisFile.getPath().equals(otherFile.getPath());
    }

    @Override
    public int hashCode() {
        return this.normalize().hashCode();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody0() {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody1$advice(TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }
}

