/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import patterntesting.runtime.io.ExtendedFile;

public final class FileInputStreamReader
extends Reader {
    private final Reader delegate;
    private final File file;

    public FileInputStreamReader(File file, Charset encoding) throws FileNotFoundException {
        this.file = file;
        ExtendedFile.validate(file);
        this.delegate = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), encoding));
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.delegate.read(target);
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.delegate.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.delegate.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.delegate.ready();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.delegate.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return this.file.toString();
    }
}

