/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LineReader
extends BufferedReader {
    private static final Logger LOG = LoggerFactory.getLogger(LineReader.class);
    private int lineNumber = 0;

    public LineReader(Reader in) {
        super(in);
    }

    public LineReader(Reader in, int sz) {
        super(in, sz);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch == 10) {
            ++this.lineNumber;
        }
        return ch;
    }

    @Override
    public int read(char[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public String readLine() throws IOException {
        ++this.lineNumber;
        return super.readLine();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.lineNumber = 0;
    }

    @Override
    public long skip(long arg0) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public void skipLines(int n) throws IOException {
        LOG.trace("Skipping {} line(s).", (Object)n);
        int i = 0;
        while (i < n) {
            String line = this.readLine();
            if (line == null) break;
            LOG.trace(line);
            ++i;
        }
    }

    public String toString() {
        if (this.lock == null) {
            return "unsynchronized " + this.getClass().getSimpleName();
        }
        String s = this.lock.toString();
        if (s.contains("@")) {
            return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toString(this.hashCode(), 36);
        }
        return s;
    }
}

