/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.jmx.Description;
import patterntesting.runtime.util.Converter;

public class AnnotatedStandardMBean
extends StandardMBean {
    private static final Logger LOG;
    private static final Map<String, Class<?>> primitiveClasses;

    static {
        Class[] prims;
        LOG = LoggerFactory.getLogger(AnnotatedStandardMBean.class);
        primitiveClasses = new HashMap();
        Class[] classArray = prims = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE};
        int n = prims.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            primitiveClasses.put(c.getName(), c);
            ++n2;
        }
    }

    public <T> AnnotatedStandardMBean(T impl, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(impl, mbeanInterface);
    }

    protected AnnotatedStandardMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    @Override
    protected String getDescription(MBeanOperationInfo op) {
        String descr = op.getDescription();
        Method m = AnnotatedStandardMBean.methodFor(this.getMBeanInterface(), op);
        return this.getDescriptionForMethod(descr, m);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = info.getDescription();
        Method m = this.getMethodForAttribute(info);
        return this.getDescriptionForMethod(description, m);
    }

    private String getDescriptionForMethod(String descr, Method m) {
        Description d;
        if (m != null && (d = m.getAnnotation(Description.class)) != null) {
            return d.value();
        }
        return descr;
    }

    private Method getMethodForAttribute(MBeanAttributeInfo info) {
        Method m = null;
        Iterator<String> methodNames = this.constructPossibleMethodNames(info.getName()).iterator();
        boolean found = false;
        while (!found && methodNames.hasNext()) {
            try {
                m = this.getMBeanInterface().getMethod(methodNames.next(), new Class[0]);
                found = true;
            }
            catch (NoSuchMethodException e) {
                LOG.debug(info + " not found in " + methodNames + ":", (Throwable)e);
                found = false;
            }
        }
        return m;
    }

    private List<String> constructPossibleMethodNames(String attributeName) {
        ArrayList<String> names = new ArrayList<String>();
        String capitalizedVarName = String.valueOf(attributeName.substring(0, 1).toUpperCase()) + attributeName.substring(1);
        names.add("get" + capitalizedVarName);
        names.add("is" + capitalizedVarName);
        names.add("has" + capitalizedVarName);
        names.add("are" + capitalizedVarName);
        return names;
    }

    private static Method methodFor(Class<?> mbeanInterface, MBeanOperationInfo op) {
        MBeanParameterInfo[] params = op.getSignature();
        String[] paramTypes = new String[params.length];
        int i = 0;
        while (i < params.length) {
            paramTypes[i] = params[i].getType();
            ++i;
        }
        return AnnotatedStandardMBean.findMethod(mbeanInterface, op.getName(), paramTypes);
    }

    private static Method findMethod(Class<?> mbeanInterface, String name, String ... paramTypes) {
        try {
            ClassLoader loader = mbeanInterface.getClassLoader();
            Class[] paramClasses = new Class[paramTypes.length];
            int i = 0;
            while (i < paramTypes.length) {
                paramClasses[i] = AnnotatedStandardMBean.classForName(paramTypes[i], loader);
                ++i;
            }
            return mbeanInterface.getMethod(name, paramClasses);
        }
        catch (ClassNotFoundException ex) {
            LOG.error("Cannot find all parameter classes " + Converter.toString(paramTypes) + ":", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            LOG.error("Cannot find method '" + name + "' for " + mbeanInterface + ":", (Throwable)ex);
        }
        LOG.info("Will return 'null' as fallback for {} and method '{}'.", mbeanInterface, (Object)name);
        return null;
    }

    private static Class<?> classForName(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> c = primitiveClasses.get(name);
        if (c == null) {
            c = Class.forName(name, false, loader);
        }
        return c;
    }
}

