/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTester {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTester.class);

    protected AbstractTester() {
    }

    protected static void removeClasses(Collection<?> classes, List<?> excluded) {
        classes.removeAll(excluded);
        for (Object obj : excluded) {
            Class clazz = (Class)obj;
            if (!clazz.isInterface() && !AbstractTester.isAbstract(clazz)) continue;
            AbstractTester.removeAssignableClasses(classes, clazz);
        }
    }

    private static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    private static void removeAssignableClasses(Collection<?> classes, Class<?> superclass) {
        ArrayList<Class> toBeDeleted = new ArrayList<Class>();
        for (Object obj : classes) {
            Class clazz = (Class)obj;
            if (!superclass.isAssignableFrom(clazz)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("removing " + clazz + " from list of classes...");
            }
            toBeDeleted.add(clazz);
        }
        classes.removeAll(toBeDeleted);
    }

    protected static <T> void removeClasses(Collection<Class<? extends T>> classes, Pattern ... excluded) {
        ArrayList<Class<T>> toBeExcluded = new ArrayList<Class<T>>();
        for (Class<T> clazz : classes) {
            if (!AbstractTester.matches(clazz, excluded)) continue;
            toBeExcluded.add(clazz);
        }
        AbstractTester.removeClasses(classes, toBeExcluded);
    }

    private static boolean matches(Class<?> clazz, Pattern[] excluded) {
        String classname = clazz.getName();
        int i = 0;
        while (i < excluded.length) {
            if (excluded[i].matcher(classname).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

