/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import patterntesting.runtime.io.ExtendedFile;
import patterntesting.runtime.io.FileInputStreamReader;
import patterntesting.runtime.junit.IOTester;
import patterntesting.runtime.util.StringConverter;

public class FileTester {
    private FileTester() {
    }

    public static void assertContentEquals(File file1, File file2) throws AssertionError {
        FileTester.assertContentEquals(file1, file2, Charset.defaultCharset());
    }

    public static void assertContentEquals(File file1, File file2, int from, int to) throws AssertionError {
        FileTester.assertContentEquals(file1, file2, from, to, Charset.defaultCharset());
    }

    public static void assertContentEquals(File file1, File file2, String encoding) throws AssertionError {
        FileTester.assertContentEquals(file1, file2, Charset.forName(encoding));
    }

    public static void assertContentEquals(File file1, File file2, int from, int to, String encoding) throws AssertionError {
        FileTester.assertContentEquals(file1, file2, from, to, Charset.forName(encoding));
    }

    public static void assertContentEquals(File file1, File file2, Charset encoding) throws AssertionError {
        try {
            if (FileUtils.contentEquals((File)file1, (File)file2)) {
                return;
            }
            FileTester.assertContentEquals(file1, file2, 1, Integer.MAX_VALUE, encoding);
        }
        catch (IOException ioe) {
            FileTester.throwAssertionError("can't compare " + file1 + " with " + file2, ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void assertContentEquals(File file1, File file2, int from, int to, Charset encoding) throws AssertionError {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileInputStreamReader r1 = new FileInputStreamReader(file1, encoding);
                try {
                    try (FileInputStreamReader r2 = new FileInputStreamReader(file2, encoding);){
                        IOTester.assertContentEquals((Reader)r1, (Reader)r2, from, to);
                    }
                    if (r1 == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (r1 == null) throw throwable;
                    ((Reader)r1).close();
                    throw throwable;
                }
                ((Reader)r1).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            FileTester.throwAssertionError("can't compare " + file1 + " with " + file2, ioe);
        }
    }

    public static void assertContentEquals(File file1, File file2, StringConverter converter) throws AssertionError {
        FileTester.assertContentEquals(file1, file2, Charset.defaultCharset(), converter);
    }

    public static void assertContentEquals(File file1, File file2, Charset charset, StringConverter converter) {
        FileTester.assertContentEquals(file1, file2, charset, converter, new Pattern[0]);
    }

    public static void assertContentEquals(File file1, File file2, StringConverter converter, Pattern ... ignores) {
        FileTester.assertContentEquals(file1, file2, Charset.defaultCharset(), converter, ignores);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void assertContentEquals(File file1, File file2, Charset encoding, StringConverter converter, Pattern ... ignores) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileInputStreamReader r1 = new FileInputStreamReader(file1, encoding);
                try {
                    try (FileInputStreamReader r2 = new FileInputStreamReader(file2, encoding);){
                        IOTester.assertContentEquals((Reader)r1, (Reader)r2, converter, ignores);
                    }
                    if (r1 == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (r1 == null) throw throwable;
                    ((Reader)r1).close();
                    throw throwable;
                }
                ((Reader)r1).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            FileTester.throwAssertionError("can't compare " + file1 + " with " + file2, ioe);
        }
    }

    public static void assertContentEquals(File file1, File file2, Pattern ... ignores) throws AssertionError {
        FileTester.assertContentEquals(file1, file2, Charset.defaultCharset(), ignores);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void assertContentEquals(File file1, File file2, Charset encoding, Pattern ... ignores) throws AssertionError {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileInputStreamReader r1 = new FileInputStreamReader(file1, encoding);
                try {
                    try (FileInputStreamReader r2 = new FileInputStreamReader(file2, encoding);){
                        IOTester.assertContentEquals((Reader)r1, (Reader)r2, ignores);
                    }
                    if (r1 == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (r1 == null) throw throwable;
                    ((Reader)r1).close();
                    throw throwable;
                }
                ((Reader)r1).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            FileTester.throwAssertionError("can't compare " + file1 + " with " + file2, ioe);
        }
    }

    public static void assertEquals(File file1, File file2) {
        Assertions.assertEquals((Object)new ExtendedFile(file1).normalize(), (Object)new ExtendedFile(file2).normalize());
    }

    private static void throwAssertionError(String msg, Throwable t) throws AssertionError {
        AssertionError error = new AssertionError((Object)msg);
        ((Throwable)((Object)error)).initCause(t);
        throw error;
    }
}

