/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import clazzfish.monitor.ClasspathMonitor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.junit.AbstractTester;

public final class ImmutableTester
extends AbstractTester {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableTester.class);
    private static final ClasspathMonitor classpathMonitor = ClasspathMonitor.getInstance();

    public static void assertImmutable(Class<? extends Object> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                throw new AssertionError((Object)(field + " should be final in immutable " + clazz));
            }
            ++n2;
        }
        LOG.trace("{} seems to be immutable.", clazz);
    }

    public static void assertImmutable(Package pkg) {
        assert (pkg != null);
        ImmutableTester.assertImmutableOfPackage(pkg.getName());
    }

    public static void assertImmutable(Package pkg, Class<?> ... excluded) {
        assert (pkg != null);
        ImmutableTester.assertImmutableOfPackage(pkg.getName(), excluded);
    }

    public static void assertImmutableOfPackage(String packageName) {
        Collection<Class<? extends Object>> classes = ImmutableTester.getImmutableClasses(packageName);
        ImmutableTester.assertImmutable(classes);
    }

    public static void assertImmutableOfPackage(String packageName, Class<?> ... excluded) {
        Collection<Class<? extends Object>> classes = ImmutableTester.getImmutableClasses(packageName);
        int i = 0;
        while (i < excluded.length) {
            classes.remove(excluded[i]);
            ++i;
        }
        ImmutableTester.assertImmutable(classes);
    }

    public static void assertImmutable(Collection<Class<? extends Object>> classes) {
        for (Class<? extends Object> clazz : classes) {
            ImmutableTester.assertImmutable(clazz);
        }
    }

    private static Collection<Class<? extends Object>> getImmutableClasses(String packageName) {
        assert (packageName != null);
        Collection concreteClasses = classpathMonitor.getConcreteClassList(packageName);
        ArrayList<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>(concreteClasses.size());
        for (Class clazz : concreteClasses) {
            if (clazz.getAnnotation(Immutable.class) == null) continue;
            LOG.debug("{} has @Immutable annotation.", (Object)clazz);
            classes.add(clazz);
        }
        return classes;
    }
}

