/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.junit.CollectionTester;
import patterntesting.runtime.util.Converter;

public class MapTester {
    private static final Logger LOG = LoggerFactory.getLogger(MapTester.class);

    private MapTester() {
    }

    public static void assertEquals(Map<?, ?> m1, Map<?, ?> m2) {
        Map<Object, Object> map1 = m1;
        if (m1.size() < m2.size()) {
            MapTester.assertEquals(m2, m1);
        } else if (m1.size() > m2.size()) {
            for (Map.Entry<?, ?> entry : map1.entrySet()) {
                if (m2.containsKey(entry.getKey())) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("<{}> is missing in {}.", (Object)Converter.toLongString(entry), (Object)Converter.toLongString(m2));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("<{}> is missing in {}.", (Object)Converter.toString(entry), (Object)Converter.toString(m2));
                }
                throw new AssertionError((Object)("<" + entry + "> is missing in " + Converter.toShortString(m2)));
            }
        } else {
            MapTester.assertEqualSizedMaps(m2, map1);
        }
    }

    private static void assertEqualSizedMaps(Map<?, ?> m2, Map<Object, Object> m1) throws AssertionError {
        for (Map.Entry<Object, Object> entry : m1.entrySet()) {
            Object value2 = m2.get(entry.getKey());
            if (entry.getValue() == null) {
                if (value2 == null) continue;
                LOG.debug("Key \"{}\" has different values: null <--> {}.", entry.getKey(), (Object)Converter.toString(value2));
                throw new AssertionError((Object)("key \"" + entry.getKey() + "\" has different values: null <--> " + Converter.toShortString(value2)));
            }
            if (value2 == null) {
                LOG.debug("{{}}\" is missing in {}.", entry, (Object)Converter.toString(m2));
                throw new AssertionError((Object)("{" + entry + "} is missing in " + Converter.toShortString(m2)));
            }
            if (value2.equals(entry.getValue())) continue;
            LOG.debug("Key \"{}\" has different values: {} <--> {}.", new Object[]{entry.getKey(), Converter.toString(entry.getValue()), Converter.toString(value2)});
            throw new AssertionError((Object)("key \"" + entry.getKey() + "\" has different values: " + Converter.toShortString(entry.getValue()) + " <--> " + Converter.toShortString(value2)));
        }
    }

    public static void assertEqualKeys(Map<?, ?> m1, Map<?, ?> m2) {
        CollectionTester.assertEquals(m1.keySet(), m2.keySet(), "keys differs");
    }

    public static void assertEqualValues(Map<?, ?> m1, Map<?, ?> m2) {
        CollectionTester.assertEquals(m1.values(), m2.values(), "values differs");
    }
}

