/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aspectj.runtime.internal.AroundClosure;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.util.Converter;

public final class NetworkTester {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkTester.class);
    private static final int CONNECTION_TIMEOUT_IN_MINUTES = 2;

    private NetworkTester() {
    }

    public static void assertOnline(String host) {
        NetworkTester.assertOnline(host, 2, TimeUnit.MINUTES);
    }

    public static boolean isOnline(String host) {
        return NetworkTester.isOnline(host, 2, TimeUnit.MINUTES);
    }

    public static void assertOnline(String host, int time, TimeUnit unit) {
        Assertions.assertTrue((boolean)NetworkTester.isOnline(host, time, unit), (String)(String.valueOf(host) + " is offline"));
    }

    public static boolean isOnline(String host, int time, TimeUnit unit) {
        PortScanner scanner = NetworkTester.scanPortsOf(host, time, unit);
        return scanner.openPortDetected();
    }

    private static PortScanner scanPortsOf(String host, int timeout, TimeUnit unit) {
        PortScanner scanner = new PortScanner(host);
        scanner.scanPorts(timeout, unit);
        return scanner;
    }

    public static void assertOnline(String host, int port) {
        Assertions.assertTrue((boolean)NetworkTester.isOnline(host, port), (String)(String.valueOf(host) + ":" + port + " is offline"));
    }

    public static void assertOnline(InetSocketAddress host) {
        NetworkTester.assertOnline(host.getHostName(), host.getPort());
    }

    public static void assertOnline(InetAddress host) {
        NetworkTester.assertOnline(host.getHostName());
    }

    public static void assertOnline(InetAddress host, int time, TimeUnit unit) {
        NetworkTester.assertOnline(host.getHostName(), time, unit);
    }

    public static void assertOnline(InetAddress host, int port) {
        NetworkTester.assertOnline(host.getHostName(), port);
    }

    public static boolean isOnline(String host, int port) {
        return NetworkTester.isOnline(host, port, 20L, TimeUnit.SECONDS);
    }

    public static boolean isOnline(String host, int port, long timeout, TimeUnit unit) {
        LOG.debug("Connecting to {}:{}...", (Object)host, (Object)port);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Socket> fs = executor.submit(() -> new Socket(host, port));
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Socket socket = fs.get(timeout, unit);){
                LOG.debug("Connecting to {}:{} was successful.", (Object)host, (Object)port);
                return socket.isConnected();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ex) {
            LOG.debug("Connecting to {}:{} failed ({}).", new Object[]{host, port, ex.toString()});
            LOG.trace("Details:", (Throwable)ex);
            return false;
        }
    }

    public static void assertOffline(String host) {
        NetworkTester.assertOffline(host, 2, TimeUnit.MINUTES);
    }

    public static void assertOffline(String host, int time, TimeUnit unit) {
        PortScanner scanner = NetworkTester.scanPortsOf(host, time, unit);
        Assertions.assertFalse((boolean)scanner.openPortDetected(), (String)(String.valueOf(host) + " is online"));
    }

    public static void assertOffline(String host, int port) {
        Assertions.assertFalse((boolean)NetworkTester.isOnline(host, port), (String)(String.valueOf(host) + ":" + port + " is online"));
    }

    public static void assertOffline(InetSocketAddress host) {
        NetworkTester.assertOffline(host.getHostName(), host.getPort());
    }

    public static void assertOffline(InetAddress host) {
        NetworkTester.assertOffline(host.getHostName());
    }

    public static void assertOffline(InetAddress host, int time, TimeUnit unit) {
        NetworkTester.assertOffline(host.getHostName(), time, unit);
    }

    public static void assertOffline(InetAddress host, int port) {
        NetworkTester.assertOffline(host.getHostName(), port);
    }

    public static void assertExists(URI uri) {
        Assertions.assertTrue((boolean)NetworkTester.exists(uri));
    }

    public static void assertExists(URL url) {
        Assertions.assertTrue((boolean)NetworkTester.exists(url));
    }

    public static boolean exists(URI uri) {
        try {
            return NetworkTester.exists(uri.toURL());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid URI: " + uri, ex);
        }
    }

    public static boolean exists(URL url) {
        try {
            URLConnection connection = url.openConnection();
            LOG.trace("Got connection {} to {}.", (Object)connection, (Object)url);
            connection.connect();
            LOG.debug("{} is online.", (Object)url);
            return true;
        }
        catch (IOException ioe) {
            LOG.debug("Cannot open {} ({}).", (Object)url, (Object)ioe.getMessage());
            LOG.trace("Details:", (Throwable)ioe);
            return false;
        }
    }

    private static class PortKnocker
    extends Observable
    implements Callable<Boolean> {
        private final InetSocketAddress address;
        private final Observer observer;

        public PortKnocker(InetSocketAddress address, Observer observer) {
            this.address = address;
            this.observer = observer;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        @Override
        public Boolean call() {
            boolean online = NetworkTester.isOnline(this.address.getHostName(), this.address.getPort());
            this.observer.update(this, online);
            return online;
        }
    }

    private static class PortScanner
    implements Observer {
        private final List<Future<Boolean>> startedThreads = new CopyOnWriteArrayList<Future<Boolean>>();
        private final String host;
        private long endTime;
        long openPort = 0L;

        public PortScanner(String host) {
            this.host = host;
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        public void scanPorts(int timeout, TimeUnit unit) {
            long l;
            this.endTime = (TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? PortScanner.currentTimeMillis_aroundBody1$advice(this, TimeMachineAspect.aspectOf(), null) : PortScanner.currentTimeMillis_aroundBody0(this)) + unit.toMillis(timeout);
            ExecutorService es = Executors.newFixedThreadPool(512);
            int port = 1;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    PortKnocker knocker = new PortKnocker(new InetSocketAddress(this.host, port), this);
                    Future<Boolean> t = es.submit(knocker);
                    this.startedThreads.add(t);
                    ++port;
                }
                if (port > 65535 || this.openPort != 0L) break;
                if (TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid()) {
                    l = PortScanner.currentTimeMillis_aroundBody3$advice(this, TimeMachineAspect.aspectOf(), null);
                    continue;
                }
                l = PortScanner.currentTimeMillis_aroundBody2(this);
            } while (l < this.endTime);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean openPortDetected() {
            try {
                for (Future<Boolean> future : this.startedThreads) {
                    void t;
                    if ((TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? PortScanner.currentTimeMillis_aroundBody5$advice(this, TimeMachineAspect.aspectOf(), null) : PortScanner.currentTimeMillis_aroundBody4(this)) >= this.endTime) return this.openPort > 0L;
                    long l = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? PortScanner.currentTimeMillis_aroundBody7$advice(this, TimeMachineAspect.aspectOf(), null) : PortScanner.currentTimeMillis_aroundBody6(this);
                    Boolean online = (Boolean)t.get(this.endTime - l, TimeUnit.MILLISECONDS);
                    if (!Boolean.TRUE.equals(online)) continue;
                    return true;
                }
                return this.openPort > 0L;
            }
            catch (InterruptedException | CancellationException | ExecutionException | TimeoutException ex) {
                LOG.debug("Wait was cancelled:", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
            return this.openPort > 0L;
        }

        @Override
        public void update(Observable o, Object arg) {
            boolean online = (Boolean)arg;
            if (online) {
                PortKnocker knocker = (PortKnocker)o;
                this.openPort = knocker.getAddress().getPort();
                LOG.debug("Open port {} for host '{}' found.", (Object)this.openPort, (Object)this.host);
                this.stopThreads();
            }
        }

        private void stopThreads() {
            for (Future<Boolean> t : this.startedThreads) {
                if (t.isDone() || t.isCancelled()) continue;
                t.cancel(true);
            }
            this.startedThreads.clear();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody0(PortScanner portScanner) {
            return System.currentTimeMillis();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody1$advice(PortScanner ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
            return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody2(PortScanner portScanner) {
            return System.currentTimeMillis();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody3$advice(PortScanner ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
            return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody4(PortScanner portScanner) {
            return System.currentTimeMillis();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody5$advice(PortScanner ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
            return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody6(PortScanner portScanner) {
            return System.currentTimeMillis();
        }

        private static final /* synthetic */ long currentTimeMillis_aroundBody7$advice(PortScanner ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
            return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
        }
    }
}

