/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import clazzfish.monitor.ClasspathMonitor;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.exception.DetailedAssertionError;
import patterntesting.runtime.junit.AbstractTester;
import patterntesting.runtime.junit.CloneableTester;
import patterntesting.runtime.junit.ComparableTester;
import patterntesting.runtime.junit.Failures;
import patterntesting.runtime.junit.SerializableTester;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.ReflectionHelper;

public final class ObjectTester
extends AbstractTester {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectTester.class);
    private static final ClasspathMonitor classpathMonitor = ClasspathMonitor.getInstance();

    private ObjectTester() {
    }

    public static void assertEquals(Object o1, Object o2) throws AssertionError {
        if (o1 instanceof Package) {
            Package pkg = (Package)o1;
            if (o2 instanceof Class) {
                Class c2 = (Class)o2;
                Class[] excluded = new Class[]{c2};
                ObjectTester.assertEquals(pkg, excluded);
            } else if (o2 instanceof Pattern) {
                ObjectTester.assertAllOfPackage(pkg.getName(), (Pattern)o2);
            }
        } else {
            Assertions.assertEquals((Object)o1, (Object)o2, (String)(o1.getClass() + ": objects are not equals!"));
            Assertions.assertEquals((Object)o2, (Object)o1, (String)(o1.getClass() + ": equals not symmetrical (A == B, but B != A)"));
            Assertions.assertEquals((int)o1.hashCode(), (int)o2.hashCode(), (String)(o1.getClass() + ": objects are equals but hashCode differs!"));
            if (o1 instanceof Comparable) {
                ComparableTester.assertCompareTo((Comparable)o1, (Comparable)o1);
            }
            ObjectTester.assertEqualsWithNull(o1);
        }
        LOG.info("equals/hashCode implementation of " + o1.getClass() + " seems to be ok");
    }

    public static void assertNotEquals(Object a, Object b) throws AssertionError {
        Assertions.assertFalse((boolean)a.equals(b), (String)("expected: '" + a + "' != '" + b + "'"));
        Assertions.assertFalse((boolean)b.equals(a), (String)(a.getClass() + ": equals not symmetrical (A != B, but B == A) with A = '" + a + "' and B = '" + b + "'"));
    }

    private static void assertEqualsWithNull(Object obj) {
        try {
            Assertions.assertFalse((boolean)obj.equals(null), (String)(String.valueOf(obj.getClass().getName()) + ".equals(null) should return 'false'"));
        }
        catch (RuntimeException re) {
            throw new DetailedAssertionError((Object)(String.valueOf(obj.getClass().getName()) + ".equals(..) implementation does not check (correct) for null argument"), (Throwable)re);
        }
    }

    public static void assertEquals(Serializable obj) throws NotSerializableException {
        Serializable clone = ObjectTester.clone(obj);
        ObjectTester.assertEquals(obj, clone);
    }

    public static void assertEquals(Cloneable obj) throws AssertionError {
        Cloneable clone = CloneableTester.getCloneOf(obj);
        ObjectTester.assertEquals(obj, clone);
    }

    public static void assertEquals(Class<?> clazz) throws AssertionError {
        LOG.trace("checking {}.equals...", clazz);
        Object o1 = ObjectTester.newInstanceOf(clazz);
        if (o1 instanceof Cloneable) {
            ObjectTester.assertEquals((Cloneable)o1);
        } else if (o1 instanceof Serializable) {
            try {
                ObjectTester.assertEquals((Serializable)o1);
            }
            catch (NotSerializableException nse) {
                throw new AssertionError((Object)nse);
            }
        } else {
            Object o2 = ObjectTester.newInstanceOf(clazz);
            ObjectTester.assertEquals(o1, o2);
        }
    }

    public static <T> void assertEquals(Collection<Class<? extends T>> classes) throws Failures {
        Failures failures = new Failures();
        for (Class<T> clazz : classes) {
            try {
                ObjectTester.assertEquals(clazz);
            }
            catch (AssertionError e) {
                LOG.warn("equals/hashCode implementation of " + clazz + " is NOT OK (" + ((Throwable)((Object)e)).getMessage() + ")");
                failures.add(clazz, e);
            }
        }
        if (failures.hasErrors()) {
            throw failures;
        }
    }

    public static void assertEquals(Package pkg) {
        assert (pkg != null);
        ObjectTester.assertEqualsOfPackage(pkg.getName());
    }

    public static void assertEquals(Package pkg, Class<?> ... excluded) {
        assert (pkg != null);
        ObjectTester.assertEqualsOfPackage(pkg.getName(), excluded);
    }

    public static void assertEquals(Package pkg, Pattern ... excluded) {
        ObjectTester.assertEqualsOfPackage(pkg.getName(), excluded);
    }

    public static void assertEqualsOfPackage(String packageName) {
        Collection classes = ObjectTester.getClassesWithDeclaredEquals(packageName);
        ObjectTester.assertEquals(classes);
    }

    public static void assertEqualsOfPackage(String packageName, Class<?> ... excluded) {
        List<Class<?>> excludedList = Arrays.asList(excluded);
        Collection classes = ObjectTester.getClassesWithDeclaredEquals(packageName);
        LOG.debug("{} will be excluded from check.", excludedList);
        ObjectTester.removeClasses(classes, excludedList);
        ObjectTester.assertEquals(classes);
    }

    public static void assertEqualsOfPackage(String packageName, Pattern ... excluded) {
        Collection classes = ObjectTester.getClassesWithDeclaredEquals(packageName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pattern {} will be excluded from check.", (Object)Converter.toShortString(excluded));
        }
        ObjectTester.removeClasses(classes, excluded);
        ObjectTester.assertEquals(classes);
    }

    private static Collection<Class<? extends Object>> getClassesWithDeclaredEquals(String packageName) {
        assert (packageName != null);
        Collection concreteClasses = classpathMonitor.getConcreteClassList(packageName);
        ArrayList<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>(concreteClasses.size());
        for (Class clazz : concreteClasses) {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                LOG.debug(clazz + " will be ignored (class is not public)");
                continue;
            }
            if (!ObjectTester.hasEqualsDeclared(clazz)) {
                LOG.debug(clazz + " will be ignored (equals(..) not overwritten)");
                continue;
            }
            classes.add(clazz);
        }
        return classes;
    }

    public static boolean hasEqualsDeclared(Class<?> clazz) {
        try {
            Method method = clazz.getMethod("equals", Object.class);
            Class<?> declaring = method.getDeclaringClass();
            return !declaring.equals(Object.class);
        }
        catch (SecurityException e) {
            LOG.info("can't get equals(..) method of " + clazz, (Throwable)e);
            return false;
        }
        catch (NoSuchMethodException ex) {
            LOG.trace("The equals method is not overwritten:", (Throwable)ex);
            return false;
        }
    }

    public static void assertCompareTo(Object o1, Object o2) throws AssertionError {
        ComparableTester.assertCompareTo((Comparable)o1, (Comparable)o2);
    }

    public static void assertToString(Object obj) {
        if (ObjectTester.hasToStringDefaultImpl(obj)) {
            LOG.info(obj.getClass() + " has default implementation of toString()");
        }
    }

    public static boolean hasToStringDefaultImpl(Object obj) {
        try {
            String s = obj.toString();
            return s.startsWith(String.valueOf(obj.getClass().getName()) + "@");
        }
        catch (RuntimeException ex) {
            LOG.info("The toString implementation of " + obj.getClass() + " seems to be overwritten because error happens:", (Throwable)ex);
            return false;
        }
    }

    public static boolean hasToStringDefaultImpl(Class<?> clazz) {
        Object obj = ObjectTester.newInstanceOf(clazz);
        return ObjectTester.hasToStringDefaultImpl(obj);
    }

    public static <T> void assertAll(Class<? extends T> clazz) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("checking all of " + clazz + "...");
        }
        if (ObjectTester.hasEqualsDeclared(clazz)) {
            ObjectTester.assertEquals(clazz);
        }
        if (ObjectTester.hasToStringDefaultImpl(clazz)) {
            LOG.info(clazz + " has default implementation of toString()");
        }
        if (clazz.isAssignableFrom(Serializable.class)) {
            try {
                SerializableTester.assertSerialization(clazz);
            }
            catch (NotSerializableException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (clazz.isAssignableFrom(Cloneable.class)) {
            CloneableTester.assertCloning(clazz);
        }
    }

    public static <T> void assertAll(Collection<Class<? extends T>> classes) {
        for (Class<T> clazz : classes) {
            ObjectTester.assertAll(clazz);
        }
    }

    public static void assertAll(Package pkg) {
        assert (pkg != null);
        ObjectTester.assertAllOfPackage(pkg.getName());
    }

    public static void assertAll(Package pkg, Class<?> ... excluded) {
        assert (pkg != null);
        ObjectTester.assertAllOfPackage(pkg.getName(), excluded);
    }

    public static void assertAllOfPackage(String packageName) {
        assert (packageName != null);
        ObjectTester.assertAllOfPackage(packageName, new Class[0]);
    }

    public static void assertAllOfPackage(String packageName, Class<?> ... excluded) {
        assert (packageName != null);
        List<Class<?>> excludedList = Arrays.asList(excluded);
        LOG.debug("{} will be excluded from check.", excludedList);
        Collection classes = classpathMonitor.getConcreteClassList(packageName);
        classes.removeAll(excludedList);
        ObjectTester.removeMemberClasses(classes);
        ObjectTester.assertAll(classes);
    }

    public static void assertAllOfPackage(String packageName, Pattern ... excluded) {
        assert (packageName != null);
        Collection classes = classpathMonitor.getConcreteClassList(packageName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pattern {} will be excluded from check.", (Object)Converter.toShortString(excluded));
        }
        ObjectTester.removeClasses(classes, excluded);
        ObjectTester.removeMemberClasses(classes);
        ObjectTester.assertAll(classes);
    }

    private static void removeMemberClasses(Collection<Class<? extends Object>> classes) {
        ArrayList<Class<? extends Object>> memberClasses = new ArrayList<Class<? extends Object>>();
        for (Class<? extends Object> clazz : classes) {
            if (!clazz.isMemberClass()) continue;
            memberClasses.add(clazz);
        }
        LOG.debug("Member classes {} will be also excluded from check.", memberClasses);
        classes.removeAll(memberClasses);
    }

    static Object newInstanceOf(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("can't instantiate " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("can't access ctor of " + clazz, e);
        }
    }

    static Serializable clone(Serializable orig) throws NotSerializableException {
        byte[] bytes = Converter.serialize(orig);
        try {
            return Converter.deserialize(bytes);
        }
        catch (ClassNotFoundException canthappen) {
            throw new IllegalArgumentException("cannot clone " + orig, canthappen);
        }
    }

    static Object clone(Object orig) {
        if (orig instanceof Cloneable) {
            return CloneableTester.getCloneOf((Cloneable)orig);
        }
        try {
            return ObjectTester.clone((Serializable)orig);
        }
        catch (ClassCastException e) {
            LOG.trace("{} is not serializable - fallback to attribute cloning", orig.getClass(), (Object)e);
        }
        catch (NotSerializableException nse) {
            LOG.warn("can't serialize {} - fallback to attribute cloning", orig.getClass(), (Object)nse);
        }
        Object clone = ObjectTester.newInstanceOf(orig.getClass());
        Field[] fields = orig.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            fields[i].setAccessible(true);
            if (!ReflectionHelper.isStatic(fields[i])) {
                try {
                    Object value = fields[i].get(orig);
                    fields[i].set(clone, value);
                }
                catch (IllegalAccessException ex) {
                    LOG.debug(fields[i] + " is ignored:", (Throwable)ex);
                }
            }
            ++i;
        }
        return clone;
    }
}

