/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeTester {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeTester.class);

    private RuntimeTester() {
    }

    public static void assertMaxMemory(int required) {
        long mem = (Runtime.getRuntime().maxMemory() + 524287L) / 0x100000L;
        LOG.debug("VM was started with " + mem + " MB max memory.");
        if ((long)required > mem) {
            String hint = " (use 'java -Xmx" + required + "m ...')";
            if (SystemUtils.JAVA_VENDOR.toUpperCase().startsWith("IBM")) {
                hint = "";
            }
            throw new AssertionError((Object)(String.valueOf(required) + " MB max memory required but only " + mem + " MB available" + hint));
        }
    }

    public static void assertFreeMemory(int required) {
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        if ((long)required > free) {
            System.gc();
        }
        free = (Runtime.getRuntime().freeMemory() + 524287L) / 0x100000L;
        LOG.debug(String.valueOf(free) + " MB memory is free.");
        if ((long)required > free) {
            long maxMem = Runtime.getRuntime().maxMemory() / 0x100000L + (long)required + 4L - free;
            String hint = " (use 'try -Xmx" + maxMem + "m ...')";
            throw new AssertionError((Object)(String.valueOf(required) + " MB free memory required but only " + free + " MB are free" + hint));
        }
    }
}

