/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.runtime.internal.AroundClosure;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.launcher.TestExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.NullConstants;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.annotation.Broken;
import patterntesting.runtime.annotation.IntegrationTest;
import patterntesting.runtime.annotation.RunTestOn;
import patterntesting.runtime.annotation.SkipTestOn;
import patterntesting.runtime.annotation.SmokeTest;
import patterntesting.runtime.junit.internal.TestOn;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.Environment;

public class SmokeTestExtension
implements ExecutionCondition,
TestExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SmokeTestExtension.class);
    private final Date today = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? SmokeTestExtension.init$_aroundBody1$advice(this, TimeMachineAspect.aspectOf(), null) : SmokeTestExtension.init$_aroundBody0(this);
    private final Environment env = Environment.INSTANCE;

    static {
        LOG.debug("{} is registered as JUnit extension and TestExecutionListener.", SmokeTestExtension.class);
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        ConditionEvaluationResult result = this.shouldRun(testClass);
        if (result.isDisabled()) {
            return result;
        }
        Optional testMethod = context.getTestMethod();
        if (testMethod.isPresent()) {
            return this.shouldRun((Method)testMethod.get());
        }
        return ConditionEvaluationResult.enabled((String)("Tests for " + testClass + " are enabled"));
    }

    private ConditionEvaluationResult shouldRun(Class<?> testClass) {
        if (Environment.SMOKE_TEST_ENABLED && !AnnotationSupport.isAnnotated(testClass, SmokeTest.class)) {
            LOG.debug("Tests for {} are disabled because class is not marked as @SmokeTest.", testClass);
            return ConditionEvaluationResult.disabled((String)(testClass + " disabled by '-D" + "patterntesting.runSmokeTests" + "'"));
        }
        if (AnnotationSupport.isAnnotated(testClass, IntegrationTest.class) && !Environment.INTEGRATION_TEST_ENABLED) {
            LOG.debug("Tests for {} are disabled because class is marked with @IntegrationTest.", testClass);
            return ConditionEvaluationResult.disabled((String)(testClass + " disabled - use '-D" + "patterntesting.integrationTest" + "=true' to enable it"));
        }
        ConditionEvaluationResult result = this.getBrokenEvaluationResult(testClass);
        if (!result.isDisabled()) {
            result = this.getRunOnEvaluationResult(testClass);
        }
        if (!result.isDisabled()) {
            result = this.getSkipOnEvaluationResult(testClass);
        }
        return result;
    }

    private ConditionEvaluationResult shouldRun(Method testMethod) {
        if (Environment.SMOKE_TEST_ENABLED && !AnnotationSupport.isAnnotated((AnnotatedElement)testMethod, SmokeTest.class)) {
            LOG.debug("{} is disabled because method is not marked as @SmokeTest.", (Object)testMethod);
            return ConditionEvaluationResult.disabled((String)(testMethod + " disabled for " + "patterntesting.runSmokeTests"));
        }
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testMethod, IntegrationTest.class) && !Environment.INTEGRATION_TEST_ENABLED) {
            LOG.debug("{} is disabled because test is marked with @IntegrationTest.", (Object)testMethod);
            return ConditionEvaluationResult.disabled((String)(testMethod + " disabled - use '-D" + "patterntesting.integrationTest" + "=true' to enable it"));
        }
        ConditionEvaluationResult result = this.getBrokenEvaluationResult(testMethod);
        if (!result.isDisabled()) {
            result = this.getRunOnEvaluationResult(testMethod);
        }
        if (!result.isDisabled()) {
            result = this.getSkipOnEvaluationResult(testMethod);
        }
        return result;
    }

    private ConditionEvaluationResult getBrokenEvaluationResult(Class<?> testClass) {
        Optional annotation = AnnotationSupport.findAnnotation(testClass, Broken.class);
        if (annotation.isPresent() && this.isBroken(testClass.getName(), (Broken)annotation.get())) {
            return ConditionEvaluationResult.disabled((String)(testClass + " is disabled because class marked as @Broken"));
        }
        return ConditionEvaluationResult.enabled((String)(testClass + " is enabled"));
    }

    private ConditionEvaluationResult getBrokenEvaluationResult(Method testMethod) {
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, Broken.class);
        if (annotation.isPresent() && this.isBroken(testMethod.getName(), (Broken)annotation.get())) {
            return ConditionEvaluationResult.disabled((String)(testMethod + " is disabled because method marked as @Broken"));
        }
        return ConditionEvaluationResult.enabled((String)(testMethod + " is enabled"));
    }

    private ConditionEvaluationResult getRunOnEvaluationResult(Class<?> testClass) {
        Optional annotation = AnnotationSupport.findAnnotation(testClass, RunTestOn.class);
        if (annotation.isPresent() && !SmokeTestExtension.isRunTestOn(testClass.getName(), (RunTestOn)annotation.get())) {
            return ConditionEvaluationResult.disabled((String)(testClass + " is disabled because condition of @RunTestOn does not match"));
        }
        return ConditionEvaluationResult.enabled((String)(testClass + " is enabled"));
    }

    private ConditionEvaluationResult getRunOnEvaluationResult(Method testMethod) {
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, RunTestOn.class);
        if (annotation.isPresent() && !SmokeTestExtension.isRunTestOn(testMethod.getName(), (RunTestOn)annotation.get())) {
            return ConditionEvaluationResult.disabled((String)(testMethod + " is disabled because condition of @RunTestOn does not match"));
        }
        return ConditionEvaluationResult.enabled((String)(testMethod + " is enabled"));
    }

    private ConditionEvaluationResult getSkipOnEvaluationResult(Class<?> testClass) {
        Optional annotation = AnnotationSupport.findAnnotation(testClass, SkipTestOn.class);
        if (annotation.isPresent() && SmokeTestExtension.isSkipTestOn(testClass.getName(), (SkipTestOn)annotation.get())) {
            return ConditionEvaluationResult.disabled((String)(testClass + " is disabled because condition of @SkipTestOn matches"));
        }
        return ConditionEvaluationResult.enabled((String)(testClass + " is enabled"));
    }

    private ConditionEvaluationResult getSkipOnEvaluationResult(Method testMethod) {
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, SkipTestOn.class);
        if (annotation.isPresent() && SmokeTestExtension.isSkipTestOn(testMethod.getName(), (SkipTestOn)annotation.get())) {
            return ConditionEvaluationResult.disabled((String)(testMethod + " is disabled because condition of @SkipTestOn matches"));
        }
        return ConditionEvaluationResult.enabled((String)(testMethod + " is enabled"));
    }

    private boolean isBroken(String method, Broken broken) {
        Date till;
        String why = broken.why();
        if (StringUtils.isEmpty((CharSequence)why)) {
            why = broken.value();
        }
        if (!NullConstants.NULL_DATE.equals(till = Converter.toDate(broken.till())) && till.after(this.today)) {
            LOG.info(String.valueOf(method) + "() SKIPPED till {} because {}.", (Object)broken.till(), (Object)why);
            return true;
        }
        TestOn testOn = new TestOn(this.env);
        testOn.setOsNames(broken.osName());
        testOn.setOsArchs(broken.osArch());
        testOn.setOsVersions(broken.osVersion());
        testOn.setHosts(broken.host());
        testOn.setJavaVersions(broken.javaVersion());
        testOn.setJavaVendors(broken.javaVendor());
        testOn.setUsers(broken.user());
        testOn.setSystemProps(broken.property());
        if (testOn.matches()) {
            if (NullConstants.NULL_DATE.equals(till)) {
                if (testOn.hasReason()) {
                    LOG.info("{}() SKIPPED because {}.", (Object)method, (Object)testOn.getReason());
                }
                return true;
            }
            LOG.debug("{}() started, because it should be fixed since {}.", (Object)method, (Object)broken.till());
            return false;
        }
        return false;
    }

    private static boolean isRunTestOn(String method, RunTestOn runOn) {
        TestOn testOn = new TestOn();
        testOn.setOsNames(runOn.value(), runOn.osName());
        testOn.setOsArchs(runOn.osArch());
        testOn.setOsVersions(runOn.osVersion());
        testOn.setHosts(runOn.host());
        testOn.setJavaVersions(runOn.javaVersion());
        testOn.setJavaVendors(runOn.javaVendor());
        testOn.setUsers(runOn.user());
        testOn.setSystemProps(runOn.property());
        testOn.setDays(runOn.day());
        testOn.setTimes(runOn.time());
        if (!testOn.isValueGiven()) {
            throw new IllegalArgumentException(String.valueOf(method) + ":  @RunTestOn has no value");
        }
        if (testOn.matches()) {
            LOG.info("{} executed {}.", (Object)method, (Object)testOn.getReason());
            return true;
        }
        return false;
    }

    private static boolean isSkipTestOn(String method, SkipTestOn skipOn) {
        TestOn testOn = new TestOn();
        testOn.setOsNames(skipOn.value(), skipOn.osName());
        testOn.setOsArchs(skipOn.osArch());
        testOn.setOsVersions(skipOn.osVersion());
        testOn.setHosts(skipOn.host());
        testOn.setJavaVersions(skipOn.javaVersion());
        testOn.setJavaVendors(skipOn.javaVendor());
        testOn.setUsers(skipOn.user());
        testOn.setSystemProps(skipOn.property());
        testOn.setDays(skipOn.day());
        testOn.setTimes(skipOn.time());
        if (!testOn.isValueGiven()) {
            throw new IllegalArgumentException(String.valueOf(method) + ":  @SkipTestOn has no value");
        }
        if (testOn.matches()) {
            LOG.info("{} SKIPPED because {}.", (Object)method, (Object)testOn.getReason());
            return true;
        }
        return false;
    }

    private static final /* synthetic */ Date init$_aroundBody0(SmokeTestExtension smokeTestExtension) {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody1$advice(SmokeTestExtension ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }
}

