/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.net.Localhost;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.Environment;

public final class TestOn {
    private static final Logger LOG = LoggerFactory.getLogger(TestOn.class);
    private static final String[] EMPTY_STRINGS = new String[]{""};
    private final Environment env;
    private String[] osNames = EMPTY_STRINGS;
    private String[] osArchs = EMPTY_STRINGS;
    private String[] osVersions = EMPTY_STRINGS;
    private String[] hosts = EMPTY_STRINGS;
    private String[] javaVersions = EMPTY_STRINGS;
    private String[] javaVendors = EMPTY_STRINGS;
    private String[] users = EMPTY_STRINGS;
    private String[] systemProps = EMPTY_STRINGS;
    private int[] days = new int[0];
    private String[] times = EMPTY_STRINGS;
    private String reason;

    public TestOn() {
        this(Environment.INSTANCE);
    }

    public TestOn(Environment env) {
        this.env = env;
    }

    public void setOsNames(String[] osNames) {
        this.osNames = (String[])osNames.clone();
    }

    public void setOsNames(String[] fallback, String[] os) {
        this.osNames = StringUtils.isEmpty((CharSequence)os[0]) ? (String[])fallback.clone() : (String[])os.clone();
    }

    public void setOsArchs(String[] osArchs) {
        this.osArchs = (String[])osArchs.clone();
    }

    public void setOsVersions(String[] osVersions) {
        this.osVersions = (String[])osVersions.clone();
    }

    public void setHosts(String[] hosts) {
        this.hosts = (String[])hosts.clone();
    }

    public void setJavaVersions(String[] javaVersions) {
        this.javaVersions = (String[])javaVersions.clone();
    }

    public void setJavaVendors(String[] javaVendors) {
        this.javaVendors = (String[])javaVendors.clone();
    }

    public void setUsers(String[] users) {
        this.users = (String[])users.clone();
    }

    public void setSystemProps(String[] systemProps) {
        this.systemProps = (String[])systemProps.clone();
    }

    public void setDays(int[] days) {
        this.days = (int[])days.clone();
    }

    public void setTimes(String[] times) {
        this.times = (String[])times.clone();
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.hasReason() ? String.valueOf(this.reason) + " detected" : "";
    }

    public boolean hasReason() {
        return StringUtils.isNotBlank((CharSequence)this.reason);
    }

    public boolean matches() {
        if (!(this.matchesOs() && this.matchesJava() && this.matchesTime())) {
            return false;
        }
        if (!TestOn.matches(this.users, this.env.getUserName())) {
            return false;
        }
        if (!Environment.matchesOneOf(this.systemProps)) {
            return false;
        }
        if (!TestOn.runsOn(this.hosts)) {
            return false;
        }
        this.reason = String.valueOf(TestOn.buildReason(this.osNames[0], this.env.getOsName())) + TestOn.buildReason(this.osArchs[0], this.env.getOsArch()) + TestOn.buildReason(this.osVersions[0], this.env.getOsVersion()) + TestOn.buildReason(this.javaVersions[0], "JDK " + this.env.getJavaVersion()) + TestOn.buildReason(this.javaVendors[0], String.valueOf(this.env.getJavaVendor()) + " as vendor") + TestOn.buildReason(this.users[0], String.valueOf(this.env.getUserName()) + " as user") + TestOn.buildReason(this.systemProps[0], Converter.toString(this.systemProps)) + TestOn.buildReason(this.hosts[0], "host " + Converter.toString(this.hosts)) + (this.days.length == 0 ? "" : " day " + Converter.toString((Object)this.days)) + TestOn.buildReason(this.times[0], "time " + Converter.toString(this.times));
        return true;
    }

    private boolean matchesTime() {
        if (!this.isInDays()) {
            return false;
        }
        return this.isTimeInRange();
    }

    private boolean matchesOs() {
        return TestOn.matches(this.osNames, this.env.getOsName()) && TestOn.matches(this.osArchs, this.env.getOsArch()) && TestOn.matches(this.osVersions, this.env.getOsVersion());
    }

    private boolean matchesJava() {
        return TestOn.matches(this.javaVersions, this.env.getJavaVersion()) && TestOn.matches(this.javaVendors, this.env.getJavaVendor());
    }

    private static String buildReason(String cause, String reason) {
        return StringUtils.isEmpty((CharSequence)cause) ? "" : reason;
    }

    public boolean isValueGiven() {
        return TestOn.isValueGiven(this.osNames[0], this.osArchs[0], this.osVersions[0]) || TestOn.isValueGiven(this.javaVersions[0], this.javaVendors[0]) || TestOn.isValueGiven(this.hosts[0], this.users[0], this.systemProps[0], this.times[0]) || this.days.length > 0;
    }

    private static boolean isValueGiven(String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (StringUtils.isNotEmpty((CharSequence)val)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean matches(String[] names, String name) {
        if (StringUtils.isEmpty((CharSequence)names[0])) {
            LOG.trace("Empty names are ignored for matching of '{}'.", (Object)name);
            return true;
        }
        int i = 0;
        while (i < names.length) {
            if (TestOn.matches(names[i], name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean matches(String pattern, String name) {
        if (name.startsWith(pattern)) {
            return true;
        }
        if (pattern.contains("*") || pattern.contains("?")) {
            String regex = TestOn.wildcardToRegex(pattern);
            return name.matches(regex);
        }
        return false;
    }

    private boolean isInDays() {
        if (this.days.length == 0) {
            LOG.trace("Empty days are ignored for matching.");
            return true;
        }
        int d = TestOn.getDayOfWeek();
        int i = 0;
        while (i < this.days.length) {
            if (d == this.days[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int getDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? TestOn.init$_aroundBody1$advice(TimeMachineAspect.aspectOf(), null) : TestOn.init$_aroundBody0());
        int dow = cal.get(7);
        return (dow + 5) % 7 + 1;
    }

    private boolean isTimeInRange() {
        if (StringUtils.isEmpty((CharSequence)this.times[0])) {
            LOG.trace("Empty time ranges are ignored for matching.");
            return true;
        }
        int i = 0;
        while (i < this.times.length) {
            if (TestOn.isTimeInRage(this.times[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isTimeInRage(String fromTo) {
        Time tnow;
        String now;
        String[] range = fromTo.split("-");
        Time t1 = Converter.toTime(range[0]);
        Time t2 = Converter.toTime(range[1]);
        String from = t1.toString();
        String to = t2.toString();
        if (t2.before(t1)) {
            String beforeMidnight = t1 + "-24:00";
            String afterMidnight = "0:00-" + t2;
            return TestOn.isTimeInRage(beforeMidnight) || TestOn.isTimeInRage(afterMidnight);
        }
        if ("00:00:00".equals(to)) {
            to = "24:00:00";
        }
        return (now = (tnow = new Time(TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? TestOn.currentTimeMillis_aroundBody3$advice(TimeMachineAspect.aspectOf(), null) : TestOn.currentTimeMillis_aroundBody2())).toString()).compareTo(from) >= 0 && now.compareTo(to) <= 0;
    }

    private static boolean runsOn(String[] hosts) {
        block3: {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                if (!ArrayUtils.contains((Object[])hosts, (Object)localhost.getHostAddress()) && !TestOn.matches(hosts, localhost.getHostName())) break block3;
                return true;
            }
            catch (UnknownHostException e) {
                LOG.debug("Cannot get local InetAddress - using localhost:", (Throwable)e);
                return TestOn.runsOnLocalhost(hosts);
            }
        }
        return Localhost.matches(hosts);
    }

    private static boolean runsOnLocalhost(String[] hosts) {
        return ArrayUtils.contains((Object[])hosts, (Object)"127.0.0.1") || TestOn.containsIgnoreCase(hosts, "localhost");
    }

    private static boolean containsIgnoreCase(String[] names, String name) {
        int i = 0;
        while (i < names.length) {
            if (name.equalsIgnoreCase(names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int i = 0;
        int is = wildcard.length();
        while (i < is) {
            char c = wildcard.charAt(i);
            s.append(TestOn.charToRegex(c));
            ++i;
        }
        s.append('$');
        return s.toString();
    }

    private static String charToRegex(char c) {
        switch (c) {
            case '*': {
                return ".*";
            }
            case '?': {
                return ".";
            }
        }
        return TestOn.escapeSpecialRegexpCharacters(c);
    }

    private static String escapeSpecialRegexpCharacters(char c) {
        if ("()[]$^.{}|\\".contains(Character.toString(c))) {
            return "\\" + c;
        }
        return Character.toString(c);
    }

    private static final /* synthetic */ Date init$_aroundBody0() {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody1$advice(TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody2() {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody3$advice(TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }
}

