/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit.internal;

import clazzfish.monitor.ClasspathMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.util.Converter;

public final class XrayClassLoader
extends ClassLoader {
    private static final ClasspathMonitor classpathMonitor = ClasspathMonitor.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(XrayClassLoader.class);
    private final Map<String, Class<?>> loadedClassMap = new HashMap();

    @Override
    public Class<?> loadClass(String classname) throws ClassNotFoundException {
        Class<?> loaded = this.loadedClassMap.get(classname);
        if (loaded == null) {
            try {
                loaded = this.findClass(classname);
            }
            catch (SecurityException ce) {
                LOG.debug("Using parent to load " + classname + ":", (Throwable)ce);
                loaded = super.loadClass(classname);
            }
            this.loadedClassMap.put(classname, loaded);
        }
        return loaded;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java")) {
            return super.loadClass(name, resolve);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        LOG.trace("{} loaded with resolve={}.", c, (Object)resolve);
        return c;
    }

    public Set<Class<?>> getLoadedClasses() {
        return new HashSet(this.loadedClassMap.values());
    }

    @Override
    protected Class<?> findClass(String classname) throws ClassNotFoundException {
        URI classUri = classpathMonitor.whichClass(classname);
        try {
            byte[] data = XrayClassLoader.read(classUri);
            return this.defineClass(classname, data, 0, data.length);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("can't load class " + classname, ioe);
        }
    }

    private static byte[] read(URI uri) throws IOException {
        LOG.trace("loading " + uri + "...");
        try {
            File file = new File(uri);
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IllegalArgumentException iae) {
            String scheme = uri.getScheme();
            if ("jar".equals(scheme)) {
                LOG.debug("Will read " + uri + " as JAR:", (Throwable)iae);
                return XrayClassLoader.readJar(uri);
            }
            if ("jrt".equals(scheme)) {
                LOG.debug("Will read " + uri + " as JRT:", (Throwable)iae);
                return XrayClassLoader.readJrt(uri);
            }
            throw new IllegalArgumentException("don't know how to load " + uri, iae);
        }
    }

    private static byte[] readJar(URI uri) throws IOException {
        File file = Converter.toFile(StringUtils.substringBefore((String)uri.toString(), (String)"!"));
        String classpath = StringUtils.substringAfterLast((String)uri.toString(), (String)"!");
        JarFile jarFile = new JarFile(file);
        JarEntry entry = XrayClassLoader.getEntry(classpath, jarFile);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream istream = jarFile.getInputStream(entry);){
            return IOUtils.toByteArray((InputStream)istream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static JarEntry getEntry(String classpath, JarFile jarFile) {
        JarEntry entry = jarFile.getJarEntry(classpath);
        if (entry == null) {
            entry = jarFile.getJarEntry(classpath.substring(1));
        }
        return entry;
    }

    private static byte[] readJrt(URI uri) throws IOException {
        FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
        Path jrtPath = fs.getPath("modules", uri.getPath());
        byte[] jlo = Files.readAllBytes(jrtPath);
        return jlo;
    }
}

