/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.annotation.DrawSequenceDiagram;
import patterntesting.runtime.log.SequenceGrapher;
import patterntesting.runtime.util.JoinPointHelper;

@Aspect
public abstract class AbstractSequenceDiagramAspect {
    private static Logger log = LoggerFactory.getLogger(AbstractSequenceDiagramAspect.class);
    private static SequenceGrapher grapher = new SequenceGrapher();
    private static List<SequenceGrapher> grapherList = new CopyOnWriteArrayList<SequenceGrapher>();

    static {
        grapherList.add(grapher);
    }

    protected synchronized void startDiagram(DrawSequenceDiagram diagramAnnotation) {
        File file = new File(diagramAnnotation.value());
        this.startDiagram(file);
        grapher.setExcludeFilter(diagramAnnotation.excluded());
    }

    private void startDiagram(File file) {
        grapher = new SequenceGrapher(file);
        grapherList.add(grapher);
        log.trace("Generation of sequence diagram to {} started.", (Object)file);
    }

    protected void addToDiagram(JoinPoint jp) {
        grapher.execute(jp);
    }

    protected void returnFromDiagram(JoinPoint jp) {
        grapher.returnFromExecute(jp);
    }

    protected void returnFromDiagram(JoinPoint jp, Object returnValue) {
        grapher.returnFromExecute(jp, returnValue);
    }

    protected synchronized void closeDiagram() {
        grapher.close();
        log.trace("Sequence diagram closed.");
        int n = grapherList.size();
        grapherList.remove(n - 1);
        grapher = grapherList.get(n - 2);
    }

    @Pointcut(value="", argNames="")
    public abstract /* synthetic */ void ajc$pointcut$$applicationCode$ed1();

    @SuppressAjWarnings(value={"adviceDidNotMatch", "unmatchedSuperTypeInCall"})
    private /* synthetic */ void ajc$pointcut$$intersection$fd9() {
    }

    @Pointcut(value="(call(public * *(..)) && !call(public * org.junit..*(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$callAllMethods$108a() {
    }

    @Pointcut(value="(call(public void *(..)) && !call(public void org.junit..*(..)))", argNames="")
    private /* synthetic */ void ajc$pointcut$$callVoidMethods$114f() {
    }

    @Pointcut(value="(callAllMethods() && !callVoidMethods())", argNames="")
    private /* synthetic */ void ajc$pointcut$$callReturningMethods$11f2() {
    }

    @Pointcut(value="call(*..*.new(..))", argNames="")
    private /* synthetic */ void ajc$pointcut$$callConstructor$1251() {
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Around(value="(intersection() && callConstructor())", argNames="ajc$aroundClosure")
    public @SuppressAjWarnings(value={"adviceDidNotMatch"}) Object ajc$around$patterntesting_runtime_log_AbstractSequenceDiagramAspect$1$a884ec3e(AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        Object created = ajc$aroundClosure.run(new Object[0]);
        AbstractSequenceDiagramAspect.log.trace("--- <<create>> ---> {}", created);
        AbstractSequenceDiagramAspect.grapher.createMessage(thisJoinPoint, created);
        return created;
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Before(value="(intersection() && callAllMethods())", argNames="")
    public void ajc$before$patterntesting_runtime_log_AbstractSequenceDiagramAspect$2$b4afd1a7(JoinPoint thisJoinPoint) {
        Class<?> caller = thisJoinPoint.getThis();
        if (caller == null) {
            caller = JoinPointHelper.getCallerClass();
        }
        log.trace("{}: --- {} -->", caller, (Object)thisJoinPoint);
        grapher.message(caller, thisJoinPoint);
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @After(value="(intersection() && callVoidMethods())", argNames="")
    public void ajc$after$patterntesting_runtime_log_AbstractSequenceDiagramAspect$3$64ed823a(JoinPoint thisJoinPoint) {
        log.trace("<-----: {}", (Object)thisJoinPoint);
        grapher.returnMessage(thisJoinPoint);
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @AfterReturning(pointcut="(intersection() && callReturningMethods())", returning="ret", argNames="ret")
    public void ajc$afterReturning$patterntesting_runtime_log_AbstractSequenceDiagramAspect$4$ed062778(Object ret, JoinPoint thisJoinPoint) {
        log.trace("<-- {} ---: {}", ret, (Object)thisJoinPoint);
        grapher.returnMessage(thisJoinPoint, ret);
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$patterntesting_runtime_log_AbstractSequenceDiagramAspect$patterntesting_runtime_log_AbstractSequenceDiagramAspect$log(Logger logger) {
        log = logger;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$patterntesting_runtime_log_AbstractSequenceDiagramAspect$patterntesting_runtime_log_AbstractSequenceDiagramAspect$grapher(SequenceGrapher sequenceGrapher) {
        grapher = sequenceGrapher;
    }
}

