/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.AbstractLogger;
import patterntesting.annotation.check.runtime.NullArgsAllowed;

public final class LogRecorder
extends AbstractLogger
implements Logger {
    private static final long serialVersionUID = 20161228L;
    private static final Logger LOG = LoggerFactory.getLogger(LogRecorder.class);
    private final List<String> objects = new ArrayList<String>();
    private final List<Throwable> exceptions = new ArrayList<Throwable>();

    @NullArgsAllowed
    private synchronized void record(String obj, Throwable t) {
        this.objects.add(obj);
        this.exceptions.add(t);
    }

    @NullArgsAllowed
    private void record(Marker arg0, Object arg1, Throwable arg2) {
        String prefix = arg0 == null ? "" : arg0 + ": ";
        this.record(String.valueOf(prefix) + arg1, arg2);
    }

    private void record(Marker marker, String format, Object[] args, Throwable t) {
        if (args == null || args.length == 0) {
            this.record(marker, format, t);
        } else {
            String msg = format;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                msg = msg.replaceFirst("\\{}", Objects.toString(obj));
                ++n2;
            }
            this.record(marker, msg, t);
        }
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (String obj : this.objects) {
            text.append((Object)obj);
        }
        return text.toString().trim();
    }

    public String getRecord() {
        return this.getText();
    }

    public int getNumberOfRecords() {
        return this.objects.size();
    }

    public String toString() {
        String classname = ((Object)((Object)this)).getClass().getSimpleName();
        if (this.getNumberOfRecords() == 1) {
            return String.valueOf(classname) + "(\"" + this.getRecord() + "\")";
        }
        return String.valueOf(classname) + " with " + this.getNumberOfRecords() + " records";
    }

    protected String getFullyQualifiedCallerName() {
        throw new UnsupportedOperationException("getFullyQualifiedCallerName not yet implemented");
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String message, Object[] arguments, Throwable t) {
        LOG.trace("handleNormalizedLoggingCall({}, {}, \"{}\", {}, {}", new Object[]{level, marker, message, arguments, t});
        this.record(marker, message, arguments, t);
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }
}

