/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogWatch
extends StopWatch {
    private static final Logger LOG = LoggerFactory.getLogger(LogWatch.class);
    private long nanoStartTime;
    private long nanoEndTime;

    public LogWatch() {
        this.start();
    }

    public void start() {
        this.reset();
        super.start();
        this.nanoStartTime = System.nanoTime();
    }

    public void stop() {
        this.nanoEndTime = System.nanoTime();
        super.stop();
    }

    public void reset() {
        super.reset();
        this.nanoStartTime = 0L;
        this.nanoEndTime = 0L;
    }

    public long getElapsedTime() {
        return this.getTime();
    }

    public long getTimeInNanos() {
        long endTime = this.nanoEndTime == 0L ? System.nanoTime() : this.nanoEndTime;
        long nanoTime = endTime - this.nanoStartTime;
        if (nanoTime < 0L) {
            long milliTime = this.getTime();
            LOG.info("Will use {} ms as fallback because there was an overflow with nanoTime.", (Object)milliTime);
            nanoTime = 1000000L * milliTime;
        }
        return nanoTime;
    }

    public double getTimeInMillis() {
        return (double)this.getTimeInNanos() / 1000000.0;
    }

    public String toString() {
        double millis = this.getTimeInMillis();
        if (millis > 6000000.0) {
            return super.toString();
        }
        return LogWatch.getTimeAsString(millis);
    }

    public static String getTimeAsString(double timeInMillis) {
        return LogWatch.getTimeAsString(timeInMillis, Locale.getDefault());
    }

    public static String getTimeAsString(double timeInMillis, Locale locale) {
        if (timeInMillis > 1.0) {
            return LogWatch.getTimeAsString((long)timeInMillis, locale);
        }
        DecimalFormat nf = new DecimalFormat("#.###", new DecimalFormatSymbols(locale));
        return String.valueOf(nf.format((Object)timeInMillis)) + " ms";
    }

    public static String getTimeAsString(long timeInMillis) {
        return LogWatch.getTimeAsString(timeInMillis, Locale.ENGLISH);
    }

    public static String getTimeAsString(long timeInMillis, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("patterntesting.runtime.log.messages", locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
        if (timeInMillis > 18000000L) {
            return String.valueOf((timeInMillis + 1800000L) / 3600000L) + " " + bundle.getString("hours");
        }
        if (timeInMillis > 300000L) {
            return String.valueOf((timeInMillis + 30000L) / 60000L) + " " + bundle.getString("minutes");
        }
        if (timeInMillis > 5000L) {
            return String.valueOf((timeInMillis + 500L) / 1000L) + " " + bundle.getString("seconds");
        }
        return String.valueOf(timeInMillis) + " ms";
    }
}

