/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.io.AbstractSerializer;
import patterntesting.runtime.io.BetterFileInputStream;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.JoinPointHelper;
import patterntesting.runtime.util.SignatureHelper;

public final class ObjectPlayer {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectPlayer.class);
    private static final AbstractSerializer SERIALIZER = AbstractSerializer.getInstance();
    private final Map<String, List<Object>> loggedJoinpoints = new HashMap<String, List<Object>>();

    public ObjectPlayer(File logFile) throws IOException {
        this.load(logFile);
    }

    public Object getReturnValue(JoinPoint joinPoint) {
        String statement = JoinPointHelper.getAsLongString(joinPoint);
        if (SignatureHelper.hasReturnType(joinPoint.getSignature())) {
            return this.getReturnValue(statement);
        }
        LOG.debug("REPLAY: {}", (Object)statement);
        return null;
    }

    private Object getReturnValue(String joinPoint) {
        Object returnValue = null;
        if (this.loggedJoinpoints.containsKey(joinPoint)) {
            List<Object> loggedReturnValues = this.loggedJoinpoints.get(joinPoint);
            returnValue = loggedReturnValues.get(0);
            if (loggedReturnValues.size() > 1) {
                loggedReturnValues.remove(0);
            }
        } else {
            LOG.trace("Not recorded: {}", (Object)joinPoint);
        }
        LOG.debug("REPLAY: {} = {}", (Object)joinPoint, returnValue);
        return returnValue;
    }

    public void load(File logFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BetterFileInputStream istream = new BetterFileInputStream(logFile);){
            if (FilenameUtils.isExtension((String)logFile.getName(), (String)"gz")) {
                LOG.debug("Loading \"{}\" as compressed file...", (Object)logFile);
                this.load(new GZIPInputStream(istream));
            } else {
                LOG.debug("Loading \"{}\" as normal file...", (Object)logFile);
                this.load(istream);
            }
            LOG.debug("Loading \"{}\" sucessfully finished.", (Object)logFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void load(InputStream istream) throws IOException {
        try (ObjectInputStream oistream = SERIALIZER.createObjectInputStream(istream);){
            try {
                this.load(oistream);
                LOG.debug("{} joinpoint(s) are read from {}.", (Object)this.loggedJoinpoints.size(), (Object)istream);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("unknown object in " + istream, cnfe);
            }
        }
    }

    private void load(ObjectInputStream oistream) throws ClassNotFoundException {
        try {
            Object retValue;
            do {
                String jp = (String)oistream.readObject();
                retValue = oistream.readObject();
                this.logToMemory(jp, retValue);
            } while (retValue != null);
            LOG.debug("No more objects in {} available.", (Object)oistream);
        }
        catch (IOException ioe) {
            LOG.debug("Reading of {} stopped ({}).", (Object)oistream, (Object)ioe.getMessage());
            LOG.trace("Details:", (Throwable)ioe);
        }
    }

    private void logToMemory(String joinPoint, Object returnValue) {
        List<Object> loggedReturnValues = new ArrayList<Object>();
        if (this.loggedJoinpoints.containsKey(joinPoint)) {
            loggedReturnValues = this.loggedJoinpoints.get(joinPoint);
        }
        loggedReturnValues.add(returnValue);
        this.loggedJoinpoints.put(joinPoint, loggedReturnValues);
        if (LOG.isTraceEnabled()) {
            LOG.trace("logged (" + loggedReturnValues.size() + "): {} = {}", (Object)joinPoint, (Object)Converter.toString(returnValue));
        }
    }

    public int hashCode() {
        return this.loggedJoinpoints.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectPlayer)) {
            return false;
        }
        ObjectPlayer other = (ObjectPlayer)obj;
        return ObjectPlayer.isEquals(this.loggedJoinpoints, other.loggedJoinpoints);
    }

    private static boolean isEquals(Map<String, List<Object>> m1, Map<String, List<Object>> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<String, List<Object>> entry : m2.entrySet()) {
            if (ObjectUtils.equals(m1.get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " with " + this.loggedJoinpoints.size() + " joinpoint(s).";
    }
}

