/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.annotation.check.runtime.NullArgsAllowed;
import patterntesting.runtime.io.AbstractSerializer;
import patterntesting.runtime.io.ExtendedFile;
import patterntesting.runtime.log.AbstractLogger;
import patterntesting.runtime.util.JoinPointHelper;

public class ObjectRecorder
extends AbstractLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectRecorder.class);
    private static final AbstractSerializer serializer = AbstractSerializer.getInstance();
    private final ObjectOutputStream objStream;

    public ObjectRecorder() {
        this(ObjectRecorder.createTempLogFile("objects", ".rec"));
    }

    public ObjectRecorder(File logFile) {
        this(ExtendedFile.createOutputStreamFor(logFile));
        LOG.info("Objects will be recorded to \"{}\".", (Object)logFile);
    }

    public ObjectRecorder(OutputStream ostream) {
        super(ostream);
        try {
            this.objStream = serializer.createObjectOutputStream(ostream);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("cannot use " + ostream, ioe);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.objStream);
        super.close();
    }

    @NullArgsAllowed
    public void log(JoinPoint joinPoint, Object returnValue) {
        String statement = JoinPointHelper.getAsLongString(joinPoint);
        try {
            this.save(statement, returnValue);
        }
        catch (IOException ioe) {
            LOG.debug("Logging to {} failed:", (Object)this.objStream, (Object)ioe);
            LOG.info("{} = {}", (Object)statement, returnValue);
        }
    }

    protected void save(String joinPoint, Object returnValue) throws IOException {
        LOG.debug("RECORD: {} = {}", (Object)joinPoint, returnValue);
        this.objStream.writeObject(joinPoint);
        this.objStream.writeObject(returnValue);
        this.objStream.flush();
    }
}

