/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.annotation.check.runtime.NullArgsAllowed;
import patterntesting.runtime.exception.NotFoundException;
import patterntesting.runtime.io.ExtendedFile;
import patterntesting.runtime.log.AbstractLogger;
import patterntesting.runtime.log.internal.DrawStatement;
import patterntesting.runtime.log.internal.DrawType;
import patterntesting.runtime.log.internal.SequenceDiagramWriter;
import patterntesting.runtime.log.internal.UmlGraphWriter;
import patterntesting.runtime.util.JoinPointHelper;
import patterntesting.runtime.util.StackTraceScanner;
import patterntesting.runtime.util.regex.TypePattern;

public class SequenceGrapher
extends AbstractLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceGrapher.class);
    private final SequenceDiagramWriter diagramWriter;
    private final List<DrawStatement> statements = new ArrayList<DrawStatement>();
    private final Map<Object, String> objnames = new HashMap<Object, String>();
    private final Map<Object, DrawStatement> placeHolders = new HashMap<Object, DrawStatement>();
    private final Map<Object, String> varnames = new HashMap<Object, String>();
    private final Deque<String> callerNames = new ArrayDeque<String>();
    private TypePattern[] excludeFilter = new TypePattern[0];
    private int objectNumber = 0;

    public SequenceGrapher() {
        this(SequenceGrapher.createTempLogFile("seq-diagram", ".pic"));
    }

    public SequenceGrapher(File logFile) {
        this(ExtendedFile.createOutputStreamFor(logFile), logFile);
    }

    private SequenceGrapher(OutputStream ostream, File logFile) {
        super(ostream);
        LOG.info("Sequence diagram will be written to \"{}\".", (Object)logFile);
        String extension = FilenameUtils.getExtension((String)logFile.getName());
        if ("pic".equalsIgnoreCase(extension)) {
            this.diagramWriter = new UmlGraphWriter(ostream);
        } else {
            this.diagramWriter = new SequenceDiagramWriter(ostream);
            this.diagramWriter.writeHeaderFor(logFile);
        }
    }

    public void setExcludeFilter(String[] pattern) {
        this.excludeFilter = new TypePattern[pattern.length];
        int i = 0;
        while (i < pattern.length) {
            this.excludeFilter[i] = new TypePattern(pattern[i]);
            ++i;
        }
    }

    @Override
    public void close() {
        this.closeQuietly();
        super.close();
    }

    private void closeQuietly() {
        this.sortOutEmptyCreateMessages();
        this.writeSequenceDiagram();
        this.diagramWriter.close();
    }

    private void writeSequenceDiagram() {
        if (!this.objnames.isEmpty()) {
            this.addObjects();
        }
        this.diagramWriter.addStatements(this.statements);
        this.diagramWriter.writeSequenceDiagram();
    }

    private void sortOutEmptyCreateMessages() {
        ArrayList<DrawStatement> emptyCreateMessages = new ArrayList<DrawStatement>();
        for (DrawStatement stmt : this.statements) {
            if (stmt.getType() != DrawType.CREATE_MESSAGE || this.hasActivities(stmt)) continue;
            LOG.debug("{} will be ignored because it is a single statement.", (Object)stmt);
            emptyCreateMessages.add(stmt);
            Object toBeRemoved = this.getPlaceHolderKey(stmt.getTarget());
            this.placeHolders.remove(toBeRemoved);
            SequenceGrapher.removeValue(this.varnames, stmt.getTarget());
        }
        this.statements.removeAll(emptyCreateMessages);
    }

    private Object getPlaceHolderKey(String name) {
        for (Map.Entry<Object, DrawStatement> entry : this.placeHolders.entrySet()) {
            DrawStatement stmt = entry.getValue();
            if (!name.equals(stmt.getSender())) continue;
            return entry.getKey();
        }
        return "?";
    }

    private static void removeValue(Map<Object, String> map, String name) {
        for (Map.Entry<Object, String> entry : map.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            map.remove(entry.getKey());
            break;
        }
    }

    private void addObjects() {
        ArrayList<DrawStatement> objects = new ArrayList<DrawStatement>();
        SortedMap<String, Object> sortedObjectNames = this.getSortedObjectNames();
        String firstName = sortedObjectNames.firstKey();
        objects.add(this.getActorStatement(firstName, sortedObjectNames.get(firstName)));
        sortedObjectNames.remove(firstName);
        List<String> actorNames = this.getActorNames();
        for (Map.Entry<String, Object> entry : sortedObjectNames.entrySet()) {
            objects.add(this.getObjectStatement(entry));
        }
        Collection<DrawStatement> placeHolderStatements = this.getSortedPlaceHolders();
        for (DrawStatement stmt : placeHolderStatements) {
            objects.add(stmt);
        }
        int i = 0;
        while (i < actorNames.size()) {
            objects.add(this.getActorStatement(actorNames.get(i)));
            ++i;
        }
        this.statements.addAll(0, objects);
    }

    private SortedMap<String, Object> getSortedObjectNames() {
        TreeMap<String, Object> sortedObjectNames = new TreeMap<String, Object>(new VarnameComparator());
        for (Map.Entry<Object, String> entry : this.objnames.entrySet()) {
            Object name = entry.getKey();
            if (SequenceGrapher.isActor(name)) continue;
            sortedObjectNames.put(entry.getValue(), name);
        }
        return sortedObjectNames;
    }

    private Collection<DrawStatement> getSortedPlaceHolders() {
        TreeSet<DrawStatement> stmts = new TreeSet<DrawStatement>(new PlaceholderComparator());
        stmts.addAll(this.placeHolders.values());
        return stmts;
    }

    private List<String> getActorNames() {
        ArrayList<String> actors = new ArrayList<String>();
        for (Map.Entry<Object, String> entry : this.objnames.entrySet()) {
            Object name = entry.getKey();
            if (!SequenceGrapher.isActor(name)) continue;
            actors.add(entry.getValue());
        }
        return actors;
    }

    private static boolean isActor(Object name) {
        Field[] fields;
        Method[] methods;
        if (!(name instanceof Class)) {
            return false;
        }
        Class clazz = (Class)name;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!Modifier.isStatic(method.getModifiers()) && !method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            ++n2;
        }
        Field[] fieldArray = fields = clazz.getFields();
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            Field field = fieldArray[n];
            if (!Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private DrawStatement getActorStatement(String name) {
        Map.Entry<Object, String> entry = SequenceGrapher.getEntryOfValue(name, this.objnames);
        return this.getActorStatement(name, entry.getKey());
    }

    private DrawStatement getActorStatement(String name, Object value) {
        Class clazz = value.getClass();
        if (value instanceof Class) {
            clazz = (Class)value;
        }
        String targetName = clazz.getSimpleName();
        return new DrawStatement(DrawType.ACTOR, name, targetName);
    }

    private DrawStatement getObjectStatement(Map.Entry<String, Object> entry) {
        String targetName = DrawStatement.createTargetName(entry.getValue());
        return new DrawStatement(DrawType.OBJECT, entry.getKey(), targetName);
    }

    private static Map.Entry<Object, String> getEntryOfValue(String value, Map<Object, String> map) {
        for (Map.Entry<Object, String> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry;
        }
        throw new NotFoundException("value \"" + value + "\" not found in " + map);
    }

    private boolean hasActivities(DrawStatement drawStatement) {
        String target = drawStatement.getTarget();
        for (DrawStatement stmt : this.statements) {
            if (drawStatement.equals(stmt) || !stmt.hasActor(target)) continue;
            return true;
        }
        return false;
    }

    public void createMessage(JoinPoint call, Object result) {
        Class<?> creator = call.getThis();
        if (creator == null) {
            String classname = JoinPointHelper.getCallerOf(call).getClassName();
            try {
                creator = Class.forName(classname);
            }
            catch (ClassNotFoundException ex) {
                throw new NotFoundException(classname, ex);
            }
        }
        this.createMessage(creator, result, call.getStaticPart());
    }

    public void createMessage(Object creator, Object createdObject, JoinPoint.StaticPart jpInfo) {
        if (this.matches(creator) || this.matches(createdObject)) {
            LOG.debug("{} --creates--> {} is not logged because of exclude filter.", creator, createdObject);
            return;
        }
        String name = this.varnames.get(createdObject);
        String typeName = this.addPlaceHolder(createdObject, jpInfo);
        if (name != null) {
            LOG.trace("Creation of {} is already logged.", createdObject);
            this.objnames.remove(createdObject);
            return;
        }
        name = this.getVarnameFor(creator);
        this.addCreateMessage(name, createdObject, typeName, jpInfo);
    }

    private boolean matches(Object creator) {
        int i = 0;
        while (i < this.excludeFilter.length) {
            if (this.excludeFilter[i].matches(creator)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String addPlaceHolder(Object obj, JoinPoint.StaticPart jpInfo) {
        DrawStatement stmt = this.placeHolders.get(obj);
        if (stmt == null) {
            String name = this.objnames.get(obj);
            if (name == null) {
                name = this.addVarnameFor(obj);
            }
            stmt = new DrawStatement(DrawType.PLACEHOLDER_OBJECT, name, jpInfo);
            this.placeHolders.put(obj, stmt);
        }
        return stmt.getSender();
    }

    private String addObject(Object obj) {
        String name = this.addVarnameFor(obj);
        this.objnames.put(obj, name);
        return name;
    }

    @NullArgsAllowed
    private String getVarnameFor(Object target, JoinPoint.StaticPart jpInfo) {
        if (target == null) {
            Class targetClass = jpInfo.getSignature().getDeclaringType();
            return this.getVarnameFor(targetClass);
        }
        return this.getVarnameFor(target);
    }

    @NullArgsAllowed
    private String getVarnameFor(Object obj) {
        if (obj == null) {
            return this.getActorName();
        }
        String name = this.varnames.get(obj);
        if (name == null) {
            name = obj instanceof Class ? this.getVarnameFor((Class)obj) : this.varnames.get(obj.getClass());
        }
        if (name == null) {
            name = this.addObject(obj);
        }
        return name;
    }

    private String getVarnameFor(Class<?> clazz) {
        String name = this.varnames.get(clazz);
        if (name == null) {
            for (Map.Entry<Object, String> entry : this.varnames.entrySet()) {
                if (!clazz.equals(entry.getKey().getClass())) continue;
                return entry.getValue();
            }
            name = this.addObject(clazz);
        }
        return name;
    }

    private String getActorName() {
        String name = this.varnames.get("Actor");
        if (name == null) {
            name = this.addVarnameFor("Actor");
        }
        return name;
    }

    private String addVarnameFor(Object obj) {
        if (obj instanceof Class) {
            return this.addVarnameFor((Class)obj);
        }
        String name = this.toName(obj.getClass());
        return this.addVarname(name, obj);
    }

    private String addVarnameFor(Class<?> clazz) {
        String name = this.toName(clazz);
        return this.addVarname(name, clazz);
    }

    private String addVarname(String name, Object obj) {
        if (this.varnames.containsKey(obj)) {
            LOG.trace("{} already in map of var names.", obj);
        } else {
            this.varnames.put(obj, name);
            ++this.objectNumber;
        }
        return this.varnames.get(obj);
    }

    private String toName(Class<?> clazz) {
        return String.valueOf(clazz.getSimpleName().substring(0, 1).toUpperCase()) + Integer.toString(this.objectNumber, 36);
    }

    public void execute(JoinPoint execution) {
        DrawStatement stmt = this.getLastMessage();
        if (stmt.isFromCallJoinpoint() && stmt.hasSameSignatureAs(execution.getStaticPart())) {
            LOG.debug("Joinpoint '{}' is logged already as call.", (Object)execution);
            return;
        }
        String senderName = this.getCallerNameOf(execution);
        String targetName = this.getTargetName(execution);
        JoinPoint.StaticPart jpInfo = execution.getStaticPart();
        if (execution.getSignature() instanceof ConstructorSignature) {
            this.addCreateMessage(senderName, execution.getThis(), targetName, jpInfo);
        } else {
            this.message(senderName, targetName, jpInfo, execution.getArgs());
        }
    }

    public void returnFromExecute(JoinPoint execution) {
        this.returnFromExecute(execution, "");
    }

    public void returnFromExecute(JoinPoint execution, Object returnValue) {
        String senderName = this.getCallerNameOf(execution);
        String targetName = this.getTargetName(execution);
        String caller = this.callerNames.pop();
        LOG.trace("Caller '{}' was taken from stack.", (Object)caller);
        assert (caller.equals(senderName)) : "'" + senderName + "' was not on top of stack " + this.callerNames;
        this.addReturnMessage(senderName, targetName, returnValue, execution.getStaticPart());
    }

    private String getTargetName(JoinPoint execution) {
        Object thisObject = execution.getThis();
        if (thisObject == null) {
            StackTraceElement element = StackTraceScanner.find(execution.getSignature());
            try {
                return this.getVarnameFor(Class.forName(element.getClassName()));
            }
            catch (ClassNotFoundException ex) {
                LOG.debug("Classname of " + element + " not found.", (Throwable)ex);
                return "unknown";
            }
        }
        return this.getVarnameFor(thisObject);
    }

    private String getCallerNameOf(JoinPoint execution) {
        StackTraceElement caller = JoinPointHelper.getCallerOf(execution);
        String classname = caller.getClassName();
        for (Map.Entry<Object, String> entry : this.varnames.entrySet()) {
            if (!classname.equals(entry.getKey().getClass().getName())) continue;
            LOG.trace("Caller of {} is {}.", (Object)execution, entry);
            return entry.getValue();
        }
        LOG.trace("Caller of {} not found in {}.", (Object)execution, this.varnames);
        try {
            return this.addObject(Class.forName(caller.getClassName()));
        }
        catch (ClassNotFoundException ex) {
            LOG.info("cannot get class for {}:", (Object)caller, (Object)ex);
            return this.getActorName();
        }
    }

    public void message(JoinPoint call) {
        this.message(call.getThis(), call);
    }

    public void message(Object caller, JoinPoint call) {
        this.message(caller, call.getTarget(), call.getStaticPart(), call.getArgs());
    }

    @NullArgsAllowed
    public void message(Object sender, Object target, JoinPoint.StaticPart jpInfo, Object[] args) {
        if (this.matches(sender) || this.matches(target)) {
            LOG.debug("{} -----------> {} is not logged because of exclude filter.", sender, target);
            return;
        }
        String senderName = this.getVarnameFor(sender);
        String targetName = this.getVarnameFor(target, jpInfo);
        this.message(senderName, targetName, jpInfo, args);
    }

    private void message(String senderName, String targetName, JoinPoint.StaticPart jpInfo, Object[] args) {
        this.addMessage(senderName, targetName, jpInfo, args);
    }

    public void returnMessage(JoinPoint call) {
        this.returnMessage(call, "");
    }

    public void returnMessage(JoinPoint call, Object returnValue) {
        DrawStatement stmt = this.getLastMessage();
        if (stmt.isFromExecutionJoinpoint() && stmt.hasSameSignatureAs(call.getStaticPart())) {
            LOG.debug("Joinpoint '{}' is logged already as call.", (Object)call);
            return;
        }
        this.returnMessage(call.getTarget(), returnValue, call.getStaticPart());
    }

    public void returnMessage(Object returnee, Object returnValue, JoinPoint.StaticPart jpInfo) {
        if (this.matches(returnee)) {
            LOG.debug("{} <--{}-- is not logged because of exclude filter.", returnee, returnValue);
            return;
        }
        this.addReturnMessage(returnee, returnValue, jpInfo);
    }

    private DrawStatement getLastMessage() {
        int i = this.statements.size() - 1;
        while (i >= 0) {
            DrawStatement stmt = this.statements.get(i);
            switch (stmt.getType()) {
                case CREATE_MESSAGE: 
                case MESSAGE: 
                case RETURN_MESSAGE: {
                    return stmt;
                }
            }
            --i;
        }
        return DrawStatement.NULL;
    }

    private void addCreateMessage(String senderName, Object created, String typeName, JoinPoint.StaticPart jpInfo) {
        DrawStatement stmt = new DrawStatement(senderName, created, typeName, jpInfo);
        this.statements.add(stmt);
    }

    private void addMessage(String senderName, String targetName, JoinPoint.StaticPart jpInfo, Object[] args) {
        this.callerNames.push(senderName);
        DrawStatement stmt = new DrawStatement(senderName, targetName, jpInfo, args);
        this.statements.add(stmt);
    }

    private void addReturnMessage(Object returnee, Object returnValue, JoinPoint.StaticPart jpInfo) {
        String receiverName = this.callerNames.pop();
        String returneeName = this.getVarnameFor(returnee, jpInfo);
        this.addReturnMessage(receiverName, returneeName, returnValue, jpInfo);
    }

    private void addReturnMessage(String receiverName, String returneeName, Object returnValue, JoinPoint.StaticPart jpInfo) {
        DrawStatement stmt = new DrawStatement(receiverName, returneeName, returnValue, jpInfo);
        this.statements.add(stmt);
    }

    private static final class PlaceholderComparator
    implements Comparator<DrawStatement>,
    Serializable {
        private static final long serialVersionUID = 20150614L;

        private PlaceholderComparator() {
        }

        @Override
        public int compare(DrawStatement x1, DrawStatement x2) {
            VarnameComparator comparator = new VarnameComparator();
            return comparator.compare(x1.getSender(), x2.getSender());
        }
    }

    private static final class VarnameComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 20140104L;

        private VarnameComparator() {
        }

        @Override
        public int compare(String x1, String x2) {
            return VarnameComparator.toNumber(x1) - VarnameComparator.toNumber(x2);
        }

        private static int toNumber(String varname) {
            String numberPart = varname.substring(1);
            return Integer.parseInt(numberPart, 36);
        }
    }
}

