/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log.internal;

import java.util.Arrays;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import patterntesting.runtime.log.internal.DrawType;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.JoinPointHelper;
import patterntesting.runtime.util.ReflectionHelper;

public final class DrawStatement {
    public static final DrawStatement NULL = new DrawStatement(DrawType.UNKNOWN, "null", "null");
    private final DrawType type;
    private final String sender;
    private final String target;
    private final JoinPoint.StaticPart jpInfo;
    private final Object[] args;

    public DrawStatement(DrawType type, String sender, JoinPoint.StaticPart jpInfo) {
        this.type = type;
        this.sender = sender;
        this.target = null;
        this.jpInfo = jpInfo;
        this.args = null;
    }

    public DrawStatement(DrawType type, String name, String objectName) {
        this.type = type;
        this.sender = name;
        this.target = objectName;
        this.jpInfo = null;
        this.args = null;
    }

    public DrawStatement(String senderName, Object createdObject, String typeName, JoinPoint.StaticPart jpInfo) {
        this.type = DrawType.CREATE_MESSAGE;
        this.sender = senderName;
        this.target = typeName;
        this.jpInfo = jpInfo;
        this.args = Converter.toArray(DrawStatement.createTargetName(createdObject));
    }

    public static String createTargetName(Object createdObject) {
        if (createdObject instanceof Class) {
            Class clazz = (Class)createdObject;
            return ":" + clazz.getSimpleName();
        }
        String name = "";
        if (ReflectionHelper.hasId(createdObject)) {
            name = String.valueOf(name) + ReflectionHelper.getId(createdObject);
        }
        return String.valueOf(name) + ":" + createdObject.getClass().getSimpleName();
    }

    public DrawStatement(String sender, String target, JoinPoint.StaticPart jpInfo, Object[] args) {
        this.type = DrawType.MESSAGE;
        this.sender = sender;
        this.target = target;
        this.jpInfo = jpInfo;
        this.args = (Object[])args.clone();
    }

    public DrawStatement(String receiverName, String returnee, Object returnValue, JoinPoint.StaticPart jpInfo) {
        this.type = DrawType.RETURN_MESSAGE;
        this.sender = receiverName;
        this.target = returnee;
        this.jpInfo = jpInfo;
        this.args = Converter.toArray(returnValue);
    }

    public DrawType getType() {
        return this.type;
    }

    public String getSender() {
        return this.sender;
    }

    public String getTarget() {
        return this.target;
    }

    public JoinPoint.StaticPart getJpInfo() {
        return this.jpInfo;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getArgsAsString() {
        return Converter.toShortString(JoinPointHelper.getArgsAsString(this.args));
    }

    public boolean isFromCallJoinpoint() {
        return this.isFromJoinpoint("-call");
    }

    public boolean isFromExecutionJoinpoint() {
        return this.isFromJoinpoint("-execution");
    }

    private boolean isFromJoinpoint(String typename) {
        if (this.jpInfo == null) {
            return false;
        }
        return this.jpInfo.getKind().endsWith(typename);
    }

    public boolean hasSameSignatureAs(JoinPoint.StaticPart otherJpInfo) {
        if (this.jpInfo == null) {
            return false;
        }
        switch (this.type) {
            case CREATE_MESSAGE: {
                if (otherJpInfo.getSignature() instanceof ConstructorSignature) break;
                return false;
            }
            case MESSAGE: {
                if (otherJpInfo.getSignature() instanceof MethodSignature) break;
                return false;
            }
        }
        return this.jpInfo.getSignature().toLongString().equals(otherJpInfo.getSignature().toLongString());
    }

    public boolean hasActor(String name) {
        switch (this.type) {
            case CREATE_MESSAGE: 
            case MESSAGE: {
                return name.equals(this.target);
            }
            case RETURN_MESSAGE: {
                return name.equals(this.sender) || name.equals(this.target);
            }
        }
        return false;
    }

    public boolean hasMessage() {
        switch (this.type) {
            case CREATE_MESSAGE: 
            case MESSAGE: 
            case RETURN_MESSAGE: {
                return true;
            }
        }
        return false;
    }

    public boolean hasMessageToLeft() {
        switch (this.type) {
            case CREATE_MESSAGE: 
            case MESSAGE: {
                return DrawStatement.toNumber(this.sender).compareTo(DrawStatement.toNumber(this.target)) > 0;
            }
            case RETURN_MESSAGE: {
                return DrawStatement.toNumber(this.target).compareTo(DrawStatement.toNumber(this.sender)) > 0;
            }
        }
        return false;
    }

    public boolean hasMessageToRight() {
        switch (this.type) {
            case CREATE_MESSAGE: 
            case MESSAGE: 
            case RETURN_MESSAGE: {
                return !this.hasMessageToLeft();
            }
        }
        return false;
    }

    private static String toNumber(String name) {
        return name.substring(1);
    }

    public int hashCode() {
        return this.type.hashCode() + (this.sender == null ? 0 : this.sender.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DrawStatement)) {
            return false;
        }
        DrawStatement other = (DrawStatement)obj;
        return this.type == other.type && StringUtils.equals((CharSequence)this.sender, (CharSequence)other.sender) && StringUtils.equals((CharSequence)this.target, (CharSequence)other.target) && ObjectUtils.equals((Object)this.jpInfo, (Object)other.jpInfo) && Arrays.equals(this.args, other.args);
    }

    public String toString() {
        switch (this.type) {
            case ACTOR: 
            case OBJECT: 
            case PLACEHOLDER_OBJECT: {
                return (Object)((Object)this.type) + "(" + this.sender + ",\"" + this.target + "\");";
            }
            case CREATE_MESSAGE: {
                return String.valueOf(this.sender) + " --- <<create>> --> " + this.target;
            }
            case MESSAGE: {
                return String.valueOf(this.sender) + " --- " + this.jpInfo + " --> " + this.target;
            }
            case RETURN_MESSAGE: {
                return String.valueOf(this.sender) + " <-- " + this.jpInfo + " --- " + this.target;
            }
        }
        return "# " + (Object)((Object)this.type) + " statement";
    }
}

