/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.io.ExtendedFile;
import patterntesting.runtime.log.internal.DrawStatement;
import patterntesting.runtime.log.internal.DrawType;
import patterntesting.runtime.util.Converter;

public class SequenceDiagramWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceDiagramWriter.class);
    private final Writer writer;
    private final List<DrawStatement> statements = new ArrayList<DrawStatement>();
    private final Map<String, String> placeholders = new HashMap<String, String>();

    public SequenceDiagramWriter(File file) {
        this(ExtendedFile.createOutputStreamFor(file));
        this.writeHeaderFor(file);
    }

    public SequenceDiagramWriter(OutputStream ostream) {
        this(new BufferedWriter(new OutputStreamWriter(ostream, Charset.forName("UTF-8"))));
    }

    public SequenceDiagramWriter(Writer writer) {
        this.writer = writer;
    }

    public SequenceDiagramWriter(Writer writer, List<DrawStatement> statements) {
        this(writer);
        this.statements.addAll(statements);
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected List<DrawStatement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public void addStatements(Collection<DrawStatement> drawStatements) {
        this.statements.addAll(drawStatements);
    }

    public void addStatement(DrawStatement stmt) {
        this.statements.add(stmt);
    }

    public void writeSequenceDiagram() {
        for (DrawStatement stmt : this.statements) {
            switch (stmt.getType()) {
                case ACTOR: {
                    this.placeholders.put(stmt.getSender(), stmt.getTarget());
                    break;
                }
                case OBJECT: {
                    this.addToPlaceholders(stmt.getSender(), stmt.getTarget());
                    break;
                }
                case PLACEHOLDER_OBJECT: {
                    LOG.debug("Statement '{}' is ignored for generated diagram.", (Object)stmt);
                    break;
                }
                case CREATE_MESSAGE: {
                    this.writeCreateMessage(stmt);
                    break;
                }
                case MESSAGE: {
                    this.writeMessage(stmt);
                    break;
                }
                case RETURN_MESSAGE: {
                    this.writeReturnMessage(stmt);
                    break;
                }
                default: {
                    this.writeLine(stmt.toString());
                }
            }
        }
    }

    private void addToPlaceholders(String varname, String label) {
        if (this.getNumberOfObjectLabels(label) == 1) {
            this.placeholders.put(varname, SequenceDiagramWriter.toName(label, varname));
        } else {
            this.placeholders.put(varname, SequenceDiagramWriter.toName(label, ""));
        }
    }

    private int getNumberOfObjectLabels(String label) {
        int n = 0;
        for (DrawStatement stmt : this.statements) {
            if (stmt.getType() != DrawType.OBJECT || !label.equals(stmt.getSender())) continue;
            ++n;
        }
        return n;
    }

    protected void writeCreateMessage(DrawStatement stmt) {
        String name = SequenceDiagramWriter.toName((String)stmt.getArgs()[0], stmt.getTarget());
        this.placeholders.put(stmt.getTarget(), name);
        this.writeLine("# " + this.placeholders.get(stmt.getSender()) + " ->  +" + name + ": <<create>>");
    }

    protected void writeMessage(DrawStatement stmt) {
        JoinPoint.StaticPart jpInfo = stmt.getJpInfo();
        String target = stmt.getTarget();
        this.writeLine(String.valueOf(this.placeholders.get(stmt.getSender())) + " ->  +" + this.placeholders.get(target) + ": " + jpInfo.getSignature().getName() + stmt.getArgsAsString());
    }

    protected void writeReturnMessage(DrawStatement stmt) {
        this.writeLine(String.valueOf(this.placeholders.get(stmt.getTarget())) + " --> -" + this.placeholders.get(stmt.getSender()) + ": " + Converter.toShortString(stmt.getArgs()[0]));
    }

    private static String toName(String label, String varname) {
        String[] parts = label.split(":");
        String name = parts[0];
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = varname;
        }
        name = String.valueOf(parts[1]) + " " + name;
        return name.trim();
    }

    public final void writeHeaderFor(File file) {
        this.writeLine("title " + FilenameUtils.getBaseName((String)file.getName()));
        this.writeLine("");
    }

    protected final void writeLine(String line) {
        try {
            this.getWriter().write(line.trim());
            this.getWriter().write("\n");
        }
        catch (IOException ioe) {
            LOG.debug("Writing to {} failed:", (Object)this.getWriter(), (Object)ioe);
            LOG.info(line);
        }
    }

    public void close() {
        IOUtils.closeQuietly((Writer)this.writer);
    }
}

