/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.exception.NotFoundException;
import patterntesting.runtime.io.ExtendedFile;
import patterntesting.runtime.log.internal.DrawStatement;
import patterntesting.runtime.log.internal.DrawType;
import patterntesting.runtime.log.internal.SequenceDiagramWriter;
import patterntesting.runtime.util.Converter;

public final class UmlGraphWriter
extends SequenceDiagramWriter {
    private static final Logger LOG = LoggerFactory.getLogger(UmlGraphWriter.class);

    public UmlGraphWriter(File file) {
        this(ExtendedFile.createOutputStreamFor(file));
    }

    public UmlGraphWriter(OutputStream ostream) {
        this(new BufferedWriter(new OutputStreamWriter(ostream, Charset.forName("ISO-8859-1"))));
    }

    public UmlGraphWriter(Writer writer) {
        this(writer, new ArrayList<DrawStatement>());
    }

    public UmlGraphWriter(Writer writer, List<DrawStatement> statements) {
        super(writer, statements);
        this.writeTemplate("seq-head.template");
    }

    @Override
    public void writeSequenceDiagram() {
        this.writeStatements();
        this.completeObjects();
        this.writeTemplate("seq-tail.template");
    }

    private void writeStatements() {
        if (this.getStatements().isEmpty()) {
            LOG.debug("No draw statemtents are logged.");
            return;
        }
        this.writeObjects();
        this.writeLine("");
        this.writeLine("# Message sequences");
        this.writeMessages();
    }

    private void writeObjects() {
        List<DrawStatement> objects = this.getObjects();
        for (DrawStatement stmt : objects) {
            this.writeStatement(stmt);
        }
        this.writeLine("step();");
        this.writeLine("step();");
        this.writeLine("active(" + this.getFirstActor().getSender() + ");");
    }

    private void writeMessages() {
        List<DrawStatement> messages = this.getMessages();
        DrawStatement previous = DrawStatement.NULL;
        for (DrawStatement stmt : messages) {
            if (previous.hasMessageToLeft() && stmt.hasMessageToRight()) {
                this.writeLine("step();");
            }
            if (stmt.hasMessage()) {
                previous = stmt;
            }
            this.writeStatement(stmt);
        }
    }

    private DrawStatement getFirstActor() {
        for (DrawStatement stmt : this.getStatements()) {
            if (stmt.getType() != DrawType.ACTOR) continue;
            return stmt;
        }
        throw new NotFoundException("no ACTORs in " + this.getStatements());
    }

    private List<DrawStatement> getObjects() {
        ArrayList<DrawStatement> objects = new ArrayList<DrawStatement>();
        for (DrawStatement stmt : this.getStatements()) {
            if (stmt.hasMessage()) break;
            objects.add(stmt);
        }
        return objects;
    }

    private List<DrawStatement> getMessages() {
        ArrayList<DrawStatement> messages = new ArrayList<DrawStatement>();
        for (DrawStatement stmt : this.getStatements()) {
            if (!stmt.hasMessage()) continue;
            messages.add(stmt);
        }
        return messages;
    }

    private void completeObjects() {
        this.writeLine("");
        this.writeLine("# Complete the lifelines");
        this.writeLine("step();");
        Set<String> names = this.getVarnames();
        for (String name : names) {
            this.writeLine("complete(" + name + ");");
        }
    }

    private Set<String> getVarnames() {
        TreeSet<String> varnames = new TreeSet<String>();
        for (DrawStatement stmt : this.getStatements()) {
            switch (stmt.getType()) {
                case CREATE_MESSAGE: 
                case MESSAGE: {
                    varnames.add(stmt.getSender());
                    varnames.add(stmt.getTarget());
                    break;
                }
                default: {
                    LOG.trace("{} is not used to get variable names.", (Object)stmt);
                }
            }
        }
        return varnames;
    }

    private void writeTemplate(String resource) {
        InputStream istream = this.getClass().getResourceAsStream(resource);
        if (istream == null) {
            LOG.warn("Resource \"{}\" not found - content will be missing in generated diagram.", (Object)resource);
        } else {
            try {
                try {
                    String head = IOUtils.toString((InputStream)istream, (String)"ISO-8859-1");
                    this.getWriter().write(head);
                }
                catch (IOException ioe) {
                    LOG.warn("Content of \"" + resource + "\" will be missing in generated diagram.", (Throwable)ioe);
                    IOUtils.closeQuietly((InputStream)istream);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)istream);
            }
        }
    }

    private void writeStatement(DrawStatement stmt) {
        switch (stmt.getType()) {
            case ACTOR: {
                this.writeObject(stmt, "actor");
                break;
            }
            case OBJECT: {
                this.writeObject(stmt, "object");
                break;
            }
            case PLACEHOLDER_OBJECT: {
                this.writeLine("placeholder_object(" + stmt.getSender() + ");");
                break;
            }
            case CREATE_MESSAGE: {
                this.writeCreateMessage(stmt);
                break;
            }
            case MESSAGE: {
                this.writeMessage(stmt);
                break;
            }
            case RETURN_MESSAGE: {
                this.writeReturnMessage(stmt);
                break;
            }
            default: {
                this.writeLine("# " + stmt);
            }
        }
    }

    private void writeObject(DrawStatement stmt, String type) {
        this.writeLine(UmlGraphWriter.getBoxwidStatementFor(stmt.getTarget()));
        this.writeLine(String.valueOf(type) + "(" + stmt.getSender() + ",\"" + stmt.getTarget() + "\");");
    }

    private static String getBoxwidStatementFor(String name) {
        return "boxwid = " + UmlGraphWriter.getBoxwidFor(name) + ";";
    }

    private static String getBoxwidFor(String name) {
        int length = name.length() + 1;
        if (length > 16) {
            return "1.5";
        }
        if (length > 10) {
            return "1.0";
        }
        return "0.75";
    }

    @Override
    protected void writeCreateMessage(DrawStatement stmt) {
        String classname = (String)stmt.getArgs()[0];
        this.writeLine(UmlGraphWriter.getBoxwidStatementFor(classname));
        this.writeLine("\n# --> " + stmt.getJpInfo());
        this.writeLine("create_message(" + stmt.getSender() + "," + stmt.getTarget() + ",\"" + classname + "\");");
    }

    @Override
    protected void writeMessage(DrawStatement stmt) {
        if (stmt.hasMessageToLeft()) {
            this.writeLine("step();");
        }
        JoinPoint.StaticPart jpInfo = stmt.getJpInfo();
        this.writeLine("\n# --> " + jpInfo);
        this.writeLine("message(" + stmt.getSender() + "," + stmt.getTarget() + ",\"" + jpInfo.getSignature().getName() + StringEscapeUtils.escapeJava((String)stmt.getArgsAsString()) + "\");");
        this.writeLine("active(" + stmt.getTarget() + ");");
    }

    @Override
    protected void writeReturnMessage(DrawStatement stmt) {
        if (stmt.hasMessageToLeft()) {
            this.writeLine("step();");
        }
        this.writeLine("\n# <-- " + stmt.getJpInfo());
        this.writeLine("return_message(" + stmt.getTarget() + "," + stmt.getSender() + ",\"" + UmlGraphWriter.toEscapedString(Converter.toShortString(stmt.getArgs()[0])) + "\");");
        this.writeLine("inactive(" + stmt.getTarget() + ");");
    }

    private static String toEscapedString(Object returnValue) {
        if (returnValue == null) {
            return "null";
        }
        return StringEscapeUtils.escapeJava((String)returnValue.toString());
    }
}

