/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.util.JoinPointHelper;

@Aspect
public abstract class AbstractProfileAspect {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProfileAspect.class);

    public abstract Logger getLog();

    @Pointcut(value="", argNames="")
    public abstract /* synthetic */ void ajc$pointcut$$applicationCode$57e();

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Around(value="applicationCode()", argNames="ajc$aroundClosure")
    public @SuppressAjWarnings(value={"adviceDidNotMatch"}) Object ajc$around$patterntesting_runtime_monitor_AbstractProfileAspect$1$d15ea11e(AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        Signature sig = thisJoinPoint.getSignature();
        AbstractProfileAspect.LOG.trace("Profiling {}...", (Object)sig);
        ProfileMonitor mon = ProfileStatistic.start(sig);
        try {
            Object object = ajc$aroundClosure.run(new Object[0]);
            return object;
        }
        finally {
            mon.stop();
            AbstractProfileAspect.LOG.trace("Profiling {} ended with {}.", (Object)sig, (Object)mon);
            this.log(thisJoinPoint, mon.getLastValue());
        }
    }

    protected void log(JoinPoint jp, double millis) {
        this.log(jp, (long)millis);
    }

    protected void log(JoinPoint jp, long millis) {
        if (millis < 20L) {
            return;
        }
        if (millis < 200L) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("+++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
            }
        } else if (millis < 2000L) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("++++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
            }
        } else if (millis < 20000L) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("+++++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
            }
        } else if (this.getLog().isWarnEnabled()) {
            this.getLog().warn("++++++ " + millis + "ms for " + JoinPointHelper.getAsString(jp));
        }
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$LOG(Logger logger) {
        LOG = logger;
    }
}

