/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.util.Converter;

public abstract class AbstractProfileMonitor
implements ProfileMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProfileMonitor.class);

    @Override
    public final int compareTo(ProfileMonitor other) {
        int diff = other.getHits() - this.getHits();
        if (diff == 0) {
            diff = this.getLabel().compareTo(other.getLabel());
        }
        if (this.getLabel().equals(other.getLabel())) {
            diff = 0;
        } else if (this.getTotal() > other.getTotal()) {
            diff = -1;
        } else if (this.getTotal() < other.getTotal()) {
            diff = 1;
        }
        LOG.trace("{} compared to {} returns {}.", new Object[]{this, other, diff});
        return diff;
    }

    @Override
    public final String getLastTime() {
        double value = this.getLastValue();
        return Converter.getTimeAsString(value, Locale.ENGLISH);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractProfileMonitor)) {
            LOG.trace("{} is not an instance of AbstractProfileMonitor.", obj);
            return false;
        }
        AbstractProfileMonitor other = (AbstractProfileMonitor)obj;
        boolean ok = this.getLabel().equals(other.getLabel());
        LOG.trace("{} equals {} is {}.", new Object[]{this, other, ok});
        return ok;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }
}

