/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.net.URLClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.util.ReflectionHelper;

public enum ClassloaderType {
    UNKNOWN("unknown"),
    SUN("sun.misc.Launcher$AppClassLoader"),
    JDK("jdk.internal.loader.ClassLoaders$AppClassLoader"),
    NET(URLClassLoader.class),
    TOMCAT("org.apache.catalina.loader.WebappClassLoader", true, "repositoryURLs"),
    TOMCAT8("org.apache.catalina.loader.WebappClassLoaderBase", true, "localRepositories"),
    WEBLOGIC("weblogic.utils.classloaders.ChangeAwareClassLoader", true),
    WEBSPHERE("com.ibm.ws.classloader.CompoundClassLoader", true, "localClassPath"),
    SUREFIRE("org.apache.maven.surefire.booter.IsolatedClassLoader");

    private static final Logger LOG;
    private Class<? extends ClassLoader> classLoader = null;
    private final String classname;
    private final String fieldname;
    private final boolean web;

    static {
        LOG = LoggerFactory.getLogger(ClassloaderType.class);
    }

    private ClassloaderType(Class<? extends ClassLoader> classLoader) {
        this(classLoader.getName(), false);
        this.classLoader = classLoader;
    }

    private ClassloaderType(String classname) {
        this(classname, false);
    }

    private ClassloaderType(String classname, boolean web) {
        this(classname, web, "");
    }

    private ClassloaderType(String classname, boolean web, String fieldname) {
        this.classname = classname;
        this.fieldname = fieldname;
        this.web = web;
    }

    public boolean isWeb() {
        return this.web;
    }

    public static ClassloaderType toClassloaderType(ClassLoader cloader) {
        ClassloaderType type;
        ClassloaderType[] clTypes;
        ClassloaderType[] classloaderTypeArray = clTypes = ClassloaderType.values();
        int n = clTypes.length;
        int n2 = 0;
        while (n2 < n) {
            type = classloaderTypeArray[n2];
            if (ClassloaderType.isAssignableClassloader(cloader.getClass(), type) && (StringUtils.isEmpty((CharSequence)type.fieldname) || ReflectionHelper.hasField(cloader, type.fieldname))) {
                return type;
            }
            ++n2;
        }
        classloaderTypeArray = clTypes;
        n = clTypes.length;
        n2 = 0;
        while (n2 < n) {
            type = classloaderTypeArray[n2];
            if (ReflectionHelper.hasField(cloader, type.fieldname)) {
                return type;
            }
            if (type.classLoader != null && type.classLoader.isAssignableFrom(cloader.getClass())) {
                return type;
            }
            ++n2;
        }
        LOG.debug("{} is considered to be a default classloader (SUN).", (Object)cloader);
        return SUN;
    }

    private static boolean isAssignableClassloader(Class<? extends ClassLoader> cloaderClass, ClassloaderType type) {
        if (cloaderClass.getName().equals(type.classname)) {
            return true;
        }
        Class<? extends ClassLoader> superclass = cloaderClass.getSuperclass();
        if (superclass == null || superclass.equals(URLClassLoader.class)) {
            return false;
        }
        return ClassloaderType.isAssignableClassloader(superclass, type);
    }

    public static ClassloaderType getCurrentClassloaderType() {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        return ClassloaderType.toClassloaderType(cloader);
    }

    public static boolean isSupported(String classloaderName) {
        ClassloaderType[] types = ClassloaderType.values();
        int i = 0;
        while (i < types.length) {
            if (classloaderName.equals(types[i].classname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getClasspathFrom(ClassLoader cloader) {
        try {
            return ReflectionHelper.getFieldValue(cloader, this.fieldname);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException(cloader + ": cannot access field '" + this.fieldname + "'", ex);
        }
    }
}

