/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import com.jamonapi.FactoryEnabled;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactoryInterface;
import com.jamonapi.NullMonitor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.monitor.JamonMonitor;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileMonitorFactory;
import patterntesting.runtime.monitor.SimpleProfileMonitor;
import patterntesting.runtime.util.SignatureHelper;

public final class JamonMonitorFactory
extends ProfileMonitorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JamonMonitorFactory.class);
    private static final Map<String, MonitorFactoryInterface> monitorFactories = new ConcurrentHashMap<String, MonitorFactoryInterface>();

    public JamonMonitorFactory(SimpleProfileMonitor rootMonitor) {
        super(rootMonitor);
    }

    @Override
    public void setMaxNumMonitors(int maxMonitors) {
        JamonMonitorFactory.setMaxNumMonitors(maxMonitors, this.rootMonitor);
        int newSize = this.getMonitors().length;
        if (newSize > maxMonitors) {
            LOG.warn("Cannot reduce max. number of monitors to {} because {} has already {} monitors stored.", new Object[]{maxMonitors, this.rootMonitor, newSize});
        }
    }

    public static void setMaxNumMonitors(int maxMonitors, ProfileMonitor rootMonitor) {
        MonitorFactoryInterface factory = JamonMonitorFactory.getMonitorFactory(rootMonitor.getLabel());
        factory.setMaxNumMonitors(maxMonitors);
    }

    private static MonitorFactoryInterface getMonitorFactory(String label) {
        MonitorFactoryInterface factory = monitorFactories.get(label);
        if (factory == null) {
            factory = new FactoryEnabled();
            monitorFactories.put(label, factory);
        }
        return factory;
    }

    @Override
    public int getMaxNumMonitors() {
        return JamonMonitorFactory.getMaxNumMonitors(this.rootMonitor);
    }

    public static int getMaxNumMonitors(ProfileMonitor rootMonitor) {
        MonitorFactoryInterface factory = JamonMonitorFactory.getMonitorFactory(rootMonitor.getLabel());
        return factory.getMaxNumMonitors();
    }

    @Override
    public void reset() {
        JamonMonitorFactory.reset(this.rootMonitor);
    }

    public static void reset(ProfileMonitor rootMonitor) {
        JamonMonitorFactory.reset(rootMonitor.getLabel());
    }

    public static synchronized void reset(String rootLabel) {
        MonitorFactoryInterface factory = JamonMonitorFactory.getMonitorFactory(rootLabel);
        factory.reset();
    }

    public static ProfileMonitor start(String label, ProfileMonitor root) {
        return JamonMonitorFactory.start(label, root.getLabel());
    }

    public static ProfileMonitor start(String label, String rootLabel) {
        MonitorFactoryInterface factory = JamonMonitorFactory.getMonitorFactory(rootLabel);
        Monitor mon = factory.start(label);
        if (mon instanceof NullMonitor) {
            LOG.debug("Limit of {} monitors reached.", (Object)factory.getMaxNumMonitors());
            JamonMonitorFactory.reduceMonitors(factory);
            mon = factory.start(label);
        }
        return new JamonMonitor(mon);
    }

    private static void reduceMonitors(MonitorFactoryInterface factory) {
        Map monitorMap = factory.getMap();
        Map.Entry first = monitorMap.entrySet().iterator().next();
        for (Map.Entry entry : monitorMap.entrySet()) {
            Monitor mon = (Monitor)entry.getValue();
            if (!mon.getFirstAccess().before(((Monitor)first.getValue()).getFirstAccess())) continue;
            first = entry;
        }
        LOG.debug("Removing {} to reduce number of monitors.", first);
        factory.remove((MonKey)first.getKey());
    }

    @Override
    public void addMonitors(List<String> labels) {
        for (String label : labels) {
            JamonMonitorFactory.start(label, this.rootMonitor.getLabel());
        }
    }

    @Override
    public ProfileMonitor getMonitor(String label) {
        return JamonMonitorFactory.getMonitor(label, (ProfileMonitor)this.rootMonitor);
    }

    public static ProfileMonitor getMonitor(Signature sig, ProfileMonitor root) {
        String label = SignatureHelper.getAsString(sig);
        return JamonMonitorFactory.getMonitor(label, root);
    }

    public static ProfileMonitor getMonitor(String label, ProfileMonitor root) {
        return JamonMonitorFactory.start(label, root);
    }

    @Override
    public ProfileMonitor[] getMonitors() {
        return JamonMonitorFactory.getMonitors(this.rootMonitor);
    }

    public static ProfileMonitor[] getMonitors(ProfileMonitor root) {
        return JamonMonitorFactory.getMonitors(root.getLabel());
    }

    public static ProfileMonitor[] getMonitors(String rootLabel) {
        MonitorFactoryInterface factory = monitorFactories.get(rootLabel);
        if (factory == null) {
            return new JamonMonitor[0];
        }
        return JamonMonitorFactory.getMonitorsFrom(factory);
    }

    private static ProfileMonitor[] getMonitorsFrom(MonitorFactoryInterface factory) {
        MonitorComposite rootMonitor = factory.getRootMonitor();
        Monitor[] monitors = rootMonitor.getMonitors();
        if (monitors == null) {
            return new JamonMonitor[0];
        }
        ProfileMonitor[] profMonitors = new JamonMonitor[monitors.length];
        int i = 0;
        while (i < monitors.length) {
            profMonitors[i] = new JamonMonitor(monitors[i]);
            ++i;
        }
        return profMonitors;
    }
}

