/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.util.Converter;

public final class MemoryGuard {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryGuard.class);
    private static final long MAX_MEM = Runtime.getRuntime().maxMemory();
    private static BackgroundLogger backgroundTask;

    private MemoryGuard() {
    }

    public static long getFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long totalMem = runtime.totalMemory();
        return runtime.freeMemory() + (MAX_MEM - totalMem);
    }

    public static int getFreeMemoryInPercent() {
        long freeMem = MemoryGuard.getFreeMemory();
        return (int)((freeMem + 50L) * 100L / MAX_MEM);
    }

    public static String getFreeMemoryAsString() {
        return Converter.getMemoryAsString(MemoryGuard.getFreeMemory());
    }

    public static void logMemory() {
        MemoryGuard.logMemory(LOG);
    }

    public static void logMemory(Logger lg) {
        int freeMemRate = MemoryGuard.getFreeMemoryInPercent();
        if (freeMemRate < 10) {
            System.gc();
            lg.trace("gc() called because free memory is below 10% ({}%)", (Object)freeMemRate);
            freeMemRate = MemoryGuard.getFreeMemoryInPercent();
        }
        String msg = MemoryGuard.getMemoryLogMessage(freeMemRate);
        if (freeMemRate < 2) {
            lg.error(msg);
        } else if (freeMemRate < 10) {
            lg.warn(msg);
        } else if (freeMemRate < 20) {
            lg.info(msg);
        } else if (freeMemRate < 50) {
            lg.debug(msg);
        } else {
            lg.trace(msg);
        }
    }

    public static String getMemoryLogMessage() {
        int freeMemRate = MemoryGuard.getFreeMemoryInPercent();
        return MemoryGuard.getMemoryLogMessage(freeMemRate);
    }

    private static String getMemoryLogMessage(int freeMemRate) {
        return String.valueOf(freeMemRate) + "% of memory is free (" + MemoryGuard.getFreeMemoryAsString() + ")";
    }

    public static synchronized void logFreeMemory(long interval) {
        if (LOG.isDebugEnabled()) {
            if (backgroundTask == null) {
                backgroundTask = new BackgroundLogger(interval);
                LOG.trace("starting " + backgroundTask + "...");
                Thread backgroundThread = new Thread((Runnable)backgroundTask, "background");
                backgroundThread.setDaemon(true);
                backgroundThread.setPriority(1);
                backgroundThread.start();
            } else {
                backgroundTask.setInterval(interval);
                LOG.trace("Interval of {} was changed.", (Object)backgroundTask);
            }
        } else {
            LOG.info("Set the log level of {} to DEBUG to enable background logging.", MemoryGuard.class);
        }
    }

    static class BackgroundLogger
    implements Runnable {
        private long interval;

        public BackgroundLogger(long interval) {
            this.interval = interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        @Override
        public void run() {
            while (this.interval > 0L) {
                MemoryGuard.logMemory();
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    LOG.debug("{} interrupted:", (Object)this, (Object)e);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            LOG.debug("{} is stopped.", (Object)this);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "(" + this.interval + "ms)";
        }
    }
}

