/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.monitor.AbstractProfileMonitor;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.SignatureHelper;

public final class SimpleProfileMonitor
extends AbstractProfileMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleProfileMonitor.class);
    private SimpleProfileMonitor parent;
    private final Map<String, SimpleProfileMonitor> childs = new ConcurrentHashMap<String, SimpleProfileMonitor>();
    private final String label;
    private long startTime;
    private double total;
    private double lastValue;
    private double min;
    private double max;
    private int hits;
    private final Date firstAccess;
    private Date lastAccess;

    public SimpleProfileMonitor() {
        this("root");
    }

    public SimpleProfileMonitor(String rootLabel) {
        this.firstAccess = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? SimpleProfileMonitor.init$_aroundBody1$advice(this, TimeMachineAspect.aspectOf(), null) : SimpleProfileMonitor.init$_aroundBody0(this);
        this.lastAccess = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? SimpleProfileMonitor.init$_aroundBody3$advice(this, TimeMachineAspect.aspectOf(), null) : SimpleProfileMonitor.init$_aroundBody2(this);
        this.reset();
        this.label = rootLabel;
    }

    @Override
    public void reset() {
        this.total = 0.0;
        this.lastValue = 0.0;
        this.min = Double.MAX_VALUE;
        this.max = 0.0;
        this.hits = 0;
        this.parent = null;
        this.childs.clear();
    }

    public SimpleProfileMonitor(Signature label, SimpleProfileMonitor parent) {
        this(SignatureHelper.getAsString(label), parent);
    }

    public SimpleProfileMonitor(String label, SimpleProfileMonitor parent) {
        this.firstAccess = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? SimpleProfileMonitor.init$_aroundBody5$advice(this, TimeMachineAspect.aspectOf(), null) : SimpleProfileMonitor.init$_aroundBody4(this);
        this.lastAccess = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? SimpleProfileMonitor.init$_aroundBody7$advice(this, TimeMachineAspect.aspectOf(), null) : SimpleProfileMonitor.init$_aroundBody6(this);
        this.reset();
        this.label = label;
        this.parent = parent;
        this.parent.addChild(this);
    }

    protected void addChild(SimpleProfileMonitor child) {
        this.childs.put(child.label, child);
    }

    public void addChildren(List<String> labels) {
        for (String lbl : labels) {
            this.addChild(lbl);
        }
    }

    public void addChild(String lbl) {
        try {
            Signature sig = SignatureHelper.getAsSignature(lbl);
            SimpleProfileMonitor child = new SimpleProfileMonitor(sig, this);
            this.addChild(child);
        }
        catch (ReflectiveOperationException ex) {
            LOG.info("Cannot add child '{}':", (Object)lbl, (Object)ex);
        }
    }

    @Override
    public ProfileMonitor[] getMonitors() {
        return this.childs.values().toArray(new SimpleProfileMonitor[this.childs.size()]);
    }

    public int getNumberOfMonitors() {
        return this.childs.size();
    }

    public void removeMonitor(SimpleProfileMonitor monitor) {
        ProfileMonitor removed = this.childs.remove(monitor.label);
        LOG.debug("{} was removed from childs.", (Object)removed);
    }

    public SimpleProfileMonitor getMonitor(Signature sig) {
        String lbl = SignatureHelper.getAsString(sig);
        return this.getMonitor(lbl);
    }

    public SimpleProfileMonitor getMonitor(String lbl) {
        if (lbl == null) {
            return null;
        }
        return this.childs.get(lbl);
    }

    @Override
    public void start() {
        this.startTime = System.nanoTime();
        this.lastAccess = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? SimpleProfileMonitor.init$_aroundBody9$advice(this, TimeMachineAspect.aspectOf(), null) : SimpleProfileMonitor.init$_aroundBody8(this);
    }

    @Override
    public void stop() {
        long time = System.nanoTime() - this.startTime;
        this.add((double)time / 1000000.0);
    }

    @Override
    public void add(double value) {
        this.lastValue = value;
        this.total += value;
        ++this.hits;
        if (this.parent != null) {
            this.parent.add(value);
        }
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
    }

    @Override
    public double getTotal() {
        return this.total;
    }

    @Override
    public double getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public double getAvg() {
        return this.total / (double)this.hits;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return String.valueOf(this.getLabel()) + " - " + this.toShortString();
    }

    @Override
    public String toShortString() {
        return "total: " + this.total + " ms / avg: " + this.getAvg() + " ms / hits: " + this.hits;
    }

    @Override
    public String toCsvHeadline() {
        return "Label; Unit; Total; Avg; Hits; Max; Min";
    }

    @Override
    public String toCsvString() {
        return String.valueOf('\"') + this.getLabel() + "\"; ms; " + this.total + "; " + this.getAvg() + "; " + this.hits + "; " + this.getMax() + "; " + this.getMin();
    }

    @Override
    public String getUnits() {
        return "ms";
    }

    @Override
    public double getActive() {
        return 0.0;
    }

    @Override
    public double getAvgActive() {
        return 0.0;
    }

    @Override
    public Date getFirstAccess() {
        return (Date)this.firstAccess.clone();
    }

    @Override
    public Date getLastAccess() {
        return (Date)this.lastAccess.clone();
    }

    @Override
    public double getMaxActive() {
        return 0.0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleProfileMonitor)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.label.hashCode();
    }

    private static final /* synthetic */ Date init$_aroundBody0(SimpleProfileMonitor simpleProfileMonitor) {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody1$advice(SimpleProfileMonitor ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }

    private static final /* synthetic */ Date init$_aroundBody2(SimpleProfileMonitor simpleProfileMonitor) {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody3$advice(SimpleProfileMonitor ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }

    private static final /* synthetic */ Date init$_aroundBody4(SimpleProfileMonitor simpleProfileMonitor) {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody5$advice(SimpleProfileMonitor ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }

    private static final /* synthetic */ Date init$_aroundBody6(SimpleProfileMonitor simpleProfileMonitor) {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody7$advice(SimpleProfileMonitor ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }

    private static final /* synthetic */ Date init$_aroundBody8(SimpleProfileMonitor simpleProfileMonitor) {
        return new Date();
    }

    private static final /* synthetic */ Date init$_aroundBody9$advice(SimpleProfileMonitor ajc$this, TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today());
    }
}

