/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Localhost {
    private static final Logger LOG = LoggerFactory.getLogger(Localhost.class);
    private static final Collection<InetAddress> inetAddresses = new ArrayList<InetAddress>();

    static {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    inetAddresses.add(address);
                }
            }
        }
        catch (SocketException ex) {
            LOG.debug("can't get local NetworkInterfaces ({})", (Object)ex.getMessage());
            LOG.trace("Details:", (Throwable)ex);
        }
    }

    private Localhost() {
    }

    public static Collection<InetAddress> getInetAddresses() {
        return Collections.unmodifiableCollection(inetAddresses);
    }

    public static boolean matches(String ... hosts) {
        return Localhost.matches(20L, TimeUnit.SECONDS, hosts);
    }

    public static boolean matches(long timeout, TimeUnit unit, String ... hosts) {
        ExecutorService executor = Executors.newFixedThreadPool(hosts.length);
        Future[] future = new Future[hosts.length];
        int i = 0;
        while (i < hosts.length) {
            future[i] = Localhost.matches(executor, hosts[i]);
            ++i;
        }
        i = 0;
        while (i < hosts.length) {
            try {
                if (((Boolean)future[i].get(timeout, unit)).booleanValue()) {
                    return true;
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOG.info("Match with {} failed ({}).", (Object)hosts[i], (Object)ex.toString());
                LOG.debug("Details:", (Throwable)ex);
            }
            ++i;
        }
        return false;
    }

    private static Future<Boolean> matches(ExecutorService executor, String host) {
        return executor.submit(() -> Localhost.matches(host));
    }

    public static boolean matches(String host) {
        for (InetAddress address : inetAddresses) {
            if (!host.equals(address.getHostAddress()) && !host.equals(address.getHostName())) continue;
            return true;
        }
        return false;
    }
}

