/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Assertions {
    private static final Logger LOG = LoggerFactory.getLogger(Assertions.class);
    public static final boolean ENABLED;

    static {
        boolean assertsEnabled = false;
        try {
            assert (false);
            LOG.info("Assertions are disabled - call 'java -ea' (SunVM) to enable it).");
        }
        catch (AssertionError expected) {
            assertsEnabled = true;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Assertions are enabled:", (Throwable)((Object)expected));
            }
            LOG.info("Assertions are enabled.");
        }
        ENABLED = assertsEnabled;
    }

    private Assertions() {
    }

    public static boolean areEnabled() {
        return ENABLED;
    }
}

