/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.util.Converter;

public final class ClasspathHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathHelper.class);

    private ClasspathHelper() {
    }

    public static URI getParent(URI path, String resource) {
        String p = ClasspathHelper.removeTrailingSlash(path.toString());
        String res = ClasspathHelper.removeTrailingSlash(resource);
        String parent = StringUtils.removeEnd((String)p, (String)res);
        if ((parent = ClasspathHelper.removeTrailingSlash(parent)).endsWith("!")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        return Converter.toURI(parent);
    }

    private static String removeTrailingSlash(String s) {
        if (s.endsWith("/") || s.endsWith("\\")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static URI getParent(URI path, Class<?> clazz) {
        String resource = Converter.toResource(clazz);
        return ClasspathHelper.getParent(path, resource);
    }
}

