/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Time;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.NullConstants;
import patterntesting.runtime.log.LogWatch;

public final class Converter {
    private static final Logger LOG = LoggerFactory.getLogger(Converter.class);
    private static final String[] datePatterns = new String[]{"dd-MMM-yyyy", "dd-MM-yyyy", "yyyy-MMM-dd", "yyyy-MM-dd", "MMM-dd-yyyy", "dd MMM yyyy", "dd MM yyyy", "yyyy MMM dd", "yyyy MM dd", "MMM dd yyyy", "dd.MMM.yyyy", "dd.MM.yyyy", "yyyy.MMM.dd", "MMM.dd.yyyy"};
    private static final String[] dateTimePatterns = Converter.getDateTimePatterns();

    private Converter() {
    }

    public static String getMemoryAsString(long mem) {
        if (mem < 1000L) {
            return String.valueOf(mem) + " bytes";
        }
        if (mem < 0x100000L) {
            return String.valueOf((mem + 512L) / 1024L) + " KB";
        }
        return String.valueOf((mem + 524288L) / 0x100000L) + " MB";
    }

    public static String getTimeAsString(long timeInMillis) {
        return LogWatch.getTimeAsString(timeInMillis);
    }

    public static String getTimeAsString(double timeInMillis) {
        return Converter.getTimeAsString(timeInMillis, Locale.getDefault());
    }

    public static String getTimeAsString(double timeInMillis, Locale locale) {
        return LogWatch.getTimeAsString(timeInMillis, locale);
    }

    public static String classToResource(String name) {
        if (name == null) {
            return null;
        }
        return String.valueOf(name.replaceAll("\\.", "/")) + ".class";
    }

    public static String toResource(Class<?> clazz) {
        return Converter.classToResource(clazz.getName());
    }

    public static String packageToResource(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("\\.", "/");
    }

    public static String toResource(Package p) {
        return Converter.packageToResource(p.getName());
    }

    public static String resourceToClass(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(".class")) {
            int lastdot = name.lastIndexOf(46);
            String classname = name.substring(0, lastdot).replaceAll("[/\\\\]", "\\.");
            if (classname.startsWith(".")) {
                classname = classname.substring(1);
            }
            return classname;
        }
        return name;
    }

    public static URI toURI(URL url) {
        return Converter.toURI(url.toString());
    }

    public static URI toURI(String uri) {
        try {
            String converted = uri.replaceAll(" ", "%20");
            converted = converted.replace("file://", "file:/");
            return Converter.normalize(new URI(converted));
        }
        catch (URISyntaxException ex) {
            LOG.trace("Cannot convert '{}' to URI:", (Object)uri, (Object)ex);
            throw new IllegalArgumentException(String.valueOf(uri) + " is not a valid URI", ex);
        }
    }

    private static URI normalize(URI uri) {
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return new File(uri).toURI();
        }
        return uri;
    }

    public static File toFile(URI uri) {
        try {
            return Converter.toCanonicalFile(uri);
        }
        catch (IllegalArgumentException iae) {
            if ("jar".equalsIgnoreCase(uri.getScheme())) {
                try {
                    String fileScheme = uri.toString().substring(4);
                    return Converter.toFile(new URI(fileScheme));
                }
                catch (URISyntaxException ex) {
                    LOG.trace("Cannot convert '{}' to a file:", (Object)uri, (Object)ex);
                    throw new IllegalArgumentException("not a File: " + uri, iae);
                }
            }
            String path = uri.getPath();
            if (StringUtils.isEmpty((CharSequence)path)) {
                path = StringUtils.substringAfterLast((String)uri.toString(), (String)":");
            }
            return new File(path);
        }
    }

    private static File toCanonicalFile(URI uri) {
        File file = new File(uri);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ioe) {
            LOG.trace("Will use {} as return value:", (Object)file, (Object)ioe);
            return file;
        }
    }

    public static File toFile(String uri) {
        try {
            return Converter.toFile(new URI(uri));
        }
        catch (URISyntaxException ex) {
            LOG.trace("'{}' will be handled as file name:", (Object)uri, (Object)ex);
            return new File(uri);
        }
    }

    public static String toAbsolutePath(URI uri) {
        File file = Converter.toFile(uri);
        return file.getAbsolutePath();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            if (obj instanceof Object[]) {
                return Converter.toString((Object[])obj);
            }
            if (obj instanceof Enumeration) {
                return Converter.toString((Enumeration)obj);
            }
            return obj.toString();
        }
        catch (RuntimeException e) {
            LOG.debug("Returning empty string because of " + e);
            return "";
        }
    }

    public static String toString(Enumeration<?> enumeration) {
        if (!enumeration.hasMoreElements()) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            sbuf.append(" ,").append(enumeration.nextElement());
        }
        return sbuf.substring(2);
    }

    public static String toShortString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Class) {
            return ((Class)obj).getSimpleName();
        }
        if (obj instanceof Number) {
            return Converter.toShortString((Number)obj);
        }
        if (obj instanceof Time) {
            return Converter.toShortString((Time)obj);
        }
        if (obj.getClass().isArray()) {
            return Converter.toShortArrayString(obj);
        }
        return Converter.toAbbreviatedString(obj);
    }

    private static String toAbbreviatedString(Object obj) {
        String s = Converter.toString(obj);
        if (s.startsWith(obj.getClass().getName())) {
            int lengthPackagename = obj.getClass().getPackage().getName().length();
            return s.substring(lengthPackagename + 1);
        }
        return StringUtils.abbreviate((String)s, (int)24);
    }

    private static String toShortArrayString(Object obj) {
        StringBuilder sbuf = new StringBuilder();
        int n = Array.getLength(obj);
        if (n == 0) {
            return "";
        }
        sbuf.append(Array.get(obj, 0));
        int i = 1;
        while (i < n) {
            sbuf.append(", ");
            if (i > 2) {
                sbuf.append("...");
                break;
            }
            sbuf.append(Array.get(obj, i));
            ++i;
        }
        return sbuf.toString();
    }

    public static String toShortString(Number number) {
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(5);
        nf.setGroupingUsed(false);
        return nf.format(number);
    }

    public static String toShortString(Time time) {
        String s = time.toString();
        if (s.endsWith(":00")) {
            return s.substring(0, s.length() - 3);
        }
        return s;
    }

    public static String toLongString(Object obj) {
        if (obj instanceof Map) {
            return Converter.toLongString((Map)obj);
        }
        if (obj instanceof Object[]) {
            return Converter.toLongString((Object[])obj);
        }
        return Converter.toString(obj);
    }

    public static String toString(Object[] array) {
        return Converter.toString("[ ", " ]", array);
    }

    public static String toString(String prefix, String postfix, Object[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return String.valueOf(prefix.trim()) + postfix.trim();
        }
        StringBuilder sbuf = new StringBuilder(prefix);
        sbuf.append(Converter.toString(array[0]));
        int i = 1;
        while (i < array.length) {
            sbuf.append(", ");
            sbuf.append(Converter.toString(array[i]));
            ++i;
        }
        sbuf.append(postfix);
        return sbuf.toString();
    }

    public static String toShortString(Object[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder(Converter.toShortString(array[0]));
        int i = 1;
        while (i < array.length) {
            if (i > 2) {
                sbuf.append(", ...");
                break;
            }
            sbuf.append(", ");
            sbuf.append(Converter.toShortString(array[i]));
            ++i;
        }
        return sbuf.toString();
    }

    public static String toLongString(Map<?, ?> pairs) {
        StringBuilder buf = new StringBuilder();
        TreeSet keys = new TreeSet(pairs.keySet());
        for (Object key : keys) {
            buf.append(key);
            buf.append('=');
            buf.append(pairs.get(key));
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String toLongString(Object[] array) {
        if (array instanceof StackTraceElement[]) {
            return Converter.toLongString((StackTraceElement[])array);
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            buf.append('[');
            buf.append(i);
            buf.append("]\t");
            buf.append(Converter.toString(array[i]));
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public static String toLongString(StackTraceElement[] stacktrace) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < stacktrace.length) {
            buf.append("\tat ");
            buf.append(stacktrace[i]);
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public static String[] toStringArray(Object[] array) {
        String[] strings = new String[array.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = ObjectUtils.toString((Object)array[i]);
            ++i;
        }
        return strings;
    }

    public static String[] toStringArray(Set<? extends Object> set) {
        Object[] objects = new Object[set.size()];
        objects = set.toArray(objects);
        return Converter.toStringArray(objects);
    }

    public static String toString(Date date, String pattern) {
        return Converter.toString(date, pattern, Locale.ENGLISH);
    }

    public static String toString(Date date, String pattern, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, locale);
        return df.format(date);
    }

    public static Object[] toArray(Object ... objects) {
        return objects;
    }

    public static Date toDate(String s) {
        try {
            return Converter.toDate(s, false);
        }
        catch (IllegalArgumentException iae) {
            LOG.trace("Cannot convert '" + s + "' to Date with lenient=false:", (Throwable)iae);
            return Converter.toDate(s, true);
        }
    }

    private static Date toDate(String s, boolean lenient) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return NullConstants.NULL_DATE;
        }
        String[] patterns = dateTimePatterns;
        if (s.length() < 12) {
            patterns = datePatterns;
        }
        int i = 0;
        while (i < patterns.length) {
            try {
                return Converter.toDate(s, patterns[i], lenient);
            }
            catch (IllegalArgumentException iae) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Cannot convert '" + s + "' to Date with pattern " + patterns[i] + ":", (Throwable)iae);
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("can't convert \"" + s + "\" to date");
    }

    private static String[] getDateTimePatterns() {
        String[] timePatterns = new String[]{"H:m:s", "H:m", "h:m", "K:m", "k:m"};
        ArrayList<String> patterns = new ArrayList<String>(datePatterns.length * (timePatterns.length + 1) + 1);
        patterns.add("EEE MMM d HH:mm:ss zzz yyyy");
        int i = 0;
        while (i < datePatterns.length) {
            int j = 0;
            while (j < timePatterns.length) {
                patterns.add(String.valueOf(datePatterns[i]) + " " + timePatterns[j]);
                ++j;
            }
            ++i;
        }
        patterns.addAll(Arrays.asList(datePatterns));
        return patterns.toArray(new String[patterns.size()]);
    }

    public static Date toDate(String s, String pattern) {
        return Converter.toDate(s, pattern, true);
    }

    private static Date toDate(String s, String pattern, boolean lenient) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setLenient(lenient);
        try {
            return df.parse(s);
        }
        catch (ParseException parseException) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("trying to match " + s + " with locale \"en\"...");
            }
            df = new SimpleDateFormat(pattern, new Locale("en"));
            df.setLenient(lenient);
            try {
                return df.parse(s);
            }
            catch (ParseException e2) {
                throw new IllegalArgumentException("\"" + s + "\" does not match pattern " + pattern, e2);
            }
        }
    }

    public static Time toTime(String s) {
        String withSeconds = StringUtils.countMatches((CharSequence)s, (CharSequence)":") == 2 ? s : String.valueOf(s) + ":00";
        return Time.valueOf(withSeconds);
    }

    public static SortedSet<?> toSortedSet(Enumeration<?> enumeration) {
        TreeSet set = new TreeSet();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            set.add(element);
        }
        return set;
    }

    public static byte[] serialize(Serializable object) throws NotSerializableException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oostream = new ObjectOutputStream(byteStream);
            oostream.writeObject(object);
            oostream.close();
            byteStream.close();
        }
        catch (NotSerializableException nse) {
            throw nse;
        }
        catch (IOException canthappen) {
            throw new IllegalArgumentException(object + " can't be serialized", canthappen);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException(object.getClass() + " can't be serialized", ex);
        }
        return byteStream.toByteArray();
    }

    public static Serializable deserialize(byte[] bytes) throws ClassNotFoundException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream oistream = new ObjectInputStream(byteStream);
            Object object = oistream.readObject();
            IOUtils.closeQuietly((InputStream)oistream);
            return (Serializable)object;
        }
        catch (IOException canthappen) {
            throw new IllegalArgumentException(String.valueOf(Converter.toShortString((Object)bytes)) + " can't be deserialized", canthappen);
        }
    }
}

