/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import clazzfish.monitor.ClasspathMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.io.FileInputStreamReader;
import patterntesting.runtime.util.ClasspathHelper;
import patterntesting.runtime.util.Converter;

public class Environment {
    private static final Logger LOG = LoggerFactory.getLogger(Environment.class);
    private static final String FALSE = "false";
    public static final Environment INSTANCE = new Environment();
    public static final String DISABLE_THREADS = "patterntesting.disableThreads";
    public static final String INTEGRATION_TEST = "patterntesting.integrationTest";
    public static final String RUN_TESTS_PARALLEL = "patterntesting.runTestsParallel";
    public static final String RUN_SMOKE_TESTS = "patterntesting.runSmokeTests";
    public static final boolean INTEGRATION_TEST_ENABLED = Environment.isPropertyEnabled("patterntesting.integrationTest");
    public static final boolean SMOKE_TEST_ENABLED = Environment.isPropertyEnabled("patterntesting.runSmokeTests");

    protected Environment() {
    }

    public String getOsName() {
        return SystemUtils.OS_NAME;
    }

    public String getOsArch() {
        return SystemUtils.OS_ARCH;
    }

    public String getOsVersion() {
        return SystemUtils.OS_VERSION;
    }

    public String getJavaVersion() {
        return SystemUtils.JAVA_VERSION;
    }

    public String getJavaVendor() {
        return SystemUtils.JAVA_VENDOR;
    }

    public String getUserName() {
        return SystemUtils.USER_NAME;
    }

    public static String getName() {
        String name = Environment.getClassLoader().getClass().getName();
        String[] packages = name.split("\\.|\\$", 4);
        return String.valueOf(packages[0]) + "." + packages[1] + "." + packages[2];
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        if (cloader == null) {
            cloader = Environment.class.getClassLoader();
            LOG.warn("no ContextClassLoader found - using " + cloader);
        }
        return cloader;
    }

    public static boolean matchesOneOf(String[] props) {
        if (StringUtils.isEmpty((CharSequence)props[0])) {
            LOG.debug("Empty properties are ignored for matching of system properties.");
            return true;
        }
        int i = 0;
        while (i < props.length) {
            String prop;
            if (props[i].contains("*") || props[i].contains("?")) {
                LOG.warn("Wildcard in property \"" + props[i] + "\" is not supported!");
            }
            if (!FALSE.equalsIgnoreCase(prop = System.getProperty(props[i], FALSE))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPropertyEnabled(String key) {
        String prop = System.getProperty(key, FALSE);
        return !FALSE.equalsIgnoreCase(prop);
    }

    public static Properties loadProperties(String resource) throws IOException {
        ClassLoader cloader = Environment.getClassLoader();
        InputStream istream = cloader.getResourceAsStream(resource);
        if (istream == null && resource.startsWith("/")) {
            istream = cloader.getResourceAsStream(resource.substring(1));
        }
        if (istream == null) {
            LOG.debug("using Environment.class to get " + resource + "...");
            istream = Environment.class.getResourceAsStream(resource);
        }
        Properties props = Environment.loadProperties(istream);
        istream.close();
        return props;
    }

    public static Properties loadProperties(InputStream istream) throws IOException {
        Properties props = new Properties();
        props.load(istream);
        Properties systemProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            systemProps.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        LOG.debug("{} properties loaded from {}.", (Object)props.size(), (Object)istream);
        return props;
    }

    public static boolean areThreadsAllowed() {
        return !Environment.isGoogleAppEngine() && !Environment.isPropertyEnabled(DISABLE_THREADS);
    }

    public static boolean isGoogleAppEngine() {
        return System.getProperty("com.google.appengine.runtime.version") != null;
    }

    public static boolean isWeblogicServer() {
        return System.getProperty("weblogic.Name") != null;
    }

    public static File getLocalMavenRepositoryDir() throws IOException {
        Object[] repoDirs = new File[]{Environment.getLocalRepository(), new File(".repository").getAbsoluteFile(), new File("../.repository").getAbsoluteFile()};
        int i = 0;
        while (i < repoDirs.length) {
            if (repoDirs[i].exists() && ((File)repoDirs[i]).isDirectory()) {
                return repoDirs[i];
            }
            ++i;
        }
        throw new IOException("local maven repository not found in " + Converter.toString(repoDirs));
    }

    private static File getLocalRepository() {
        File m2Dir = new File(SystemUtils.getUserHome(), ".m2");
        File settings = new File(m2Dir, "settings.xml");
        if (settings.exists()) {
            return Environment.getLocalRepositoryFrom(settings);
        }
        return new File(m2Dir, "repository");
    }

    private static File getLocalRepositoryFrom(File settings) {
        File m2Repo = new File(settings.getParentFile(), "repository");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStreamReader reader = new FileInputStreamReader(settings, StandardCharsets.UTF_8);){
                XMLInputFactory factory = XMLInputFactory.newInstance();
                XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
                while (xmlReader.next() != 8) {
                    QName name;
                    if (!xmlReader.isStartElement() || !"localRepository".equalsIgnoreCase((name = xmlReader.getName()).getLocalPart())) continue;
                    String content = xmlReader.getElementText();
                    return new File(content);
                }
                LOG.debug("No <localRepository> found in {}.", (Object)settings);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException ex) {
            LOG.warn("Will return {} as default because cannot read {}:", new Object[]{m2Repo, settings, ex});
        }
        return m2Repo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJamonAvailable() {
        String resource = "/com/jamonapi/MonitorFactory.class";
        URL classURL = Environment.class.getResource(resource);
        if (classURL == null) {
            LOG.debug("JAMon and {} not available, using simple profiling.", (Object)resource);
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JarFile jarfile = ClasspathMonitor.whichResourceJar((URI)ClasspathHelper.getParent(classURL.toURI(), resource));){
                Manifest manifest = jarfile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                String version = attributes.getValue("version");
                if (version == null) {
                    LOG.info("JAMon in {} available for profiling.", (Object)jarfile.getName());
                    return true;
                }
                if ("JAMon 2.4".equalsIgnoreCase(version) || version.compareTo("JAMon 2.7") >= 0) {
                    LOG.info("{} available for profiling.", (Object)version);
                    return true;
                }
                LOG.info("{} not supported (only JAMon 2.4 and 2.7 or higher), using simple profiling.", (Object)version);
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException ex) {
            LOG.info("Will use simple profiling because cannot read manifest for {}:", (Object)classURL, (Object)ex);
        }
        return false;
    }
}

