/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionThrower {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionThrower.class);

    private ExceptionThrower() {
    }

    public static void provoke(Class<? extends Throwable> type) {
        Throwable t;
        try {
            t = ExceptionThrower.create(type);
        }
        catch (ReflectiveOperationException ex) {
            LOG.debug("Cannot create {}:", type, (Object)ex);
            t = ex;
        }
        Thrower.provoke(t);
    }

    public static Throwable create(Class<? extends Throwable> type) throws ReflectiveOperationException {
        try {
            Constructor<? extends Throwable> ctor = type.getConstructor(String.class);
            return ctor.newInstance("created by ExceptionThrower");
        }
        catch (InvocationTargetException ex) {
            LOG.trace("Invocation of 'new {}(String)' failed:", type, (Object)ex);
        }
        catch (NoSuchMethodException ex) {
            LOG.trace("Can't call 'new {}(String)':", type, (Object)ex);
        }
        return type.newInstance();
    }

    static final class Thrower {
        private static Throwable throwable;

        private Thrower() throws Throwable {
            throw throwable;
        }

        public static synchronized void provoke(Throwable t) {
            throwable = t;
            try {
                Thrower.class.newInstance();
            }
            catch (InstantiationException unexpected) {
                LOG.debug("can't instantiate Thrower class", (Throwable)unexpected);
            }
            catch (IllegalAccessException unexpected) {
                LOG.debug("can't access Thrower constructor", (Throwable)unexpected);
            }
        }
    }
}

