/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.CatchClauseSignature;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.FieldSignature;
import org.aspectj.lang.reflect.MethodSignature;
import patterntesting.annotation.check.runtime.MayReturnNull;
import patterntesting.annotation.check.runtime.NullArgsAllowed;
import patterntesting.runtime.annotation.DontLogMe;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.SignatureHelper;
import patterntesting.runtime.util.StackTraceScanner;

public final class JoinPointHelper {
    private static Pattern[] ADVICE_PATTERNS = new Pattern[]{Pattern.compile("ajc\\$.*"), Pattern.compile(".*\\$_aroundBody.*")};

    private JoinPointHelper() {
    }

    public static String getAsString(JoinPoint joinpoint) {
        Signature sig = joinpoint.getSignature();
        Object[] args = joinpoint.getArgs();
        if (sig instanceof FieldSignature) {
            if (args.length == 0) {
                return "get " + sig.toShortString();
            }
            return "set " + sig.toShortString() + " = " + JoinPointHelper.getArgAsString(args[0]);
        }
        if (sig instanceof CodeSignature) {
            Annotation[][] paramAnnotations = JoinPointHelper.getParameterAnnotations(joinpoint);
            return String.valueOf(SignatureHelper.getAsString(sig.getDeclaringTypeName(), sig)) + JoinPointHelper.getArgsAsString(args, paramAnnotations);
        }
        return String.valueOf(SignatureHelper.getAsString(sig.getDeclaringTypeName(), sig)) + JoinPointHelper.getArgsAsString(args);
    }

    public static String getAsShortString(JoinPoint joinpoint) {
        Signature sig = joinpoint.getSignature();
        if (sig instanceof FieldSignature) {
            return JoinPointHelper.getAsString(joinpoint);
        }
        Object[] args = joinpoint.getArgs();
        if (sig instanceof CatchClauseSignature) {
            return String.valueOf(SignatureHelper.getAsString(sig.getDeclaringType().getSimpleName(), sig)) + "(" + args[0].getClass().getName() + ")";
        }
        return String.valueOf(SignatureHelper.getAsString(sig.getDeclaringType().getSimpleName(), sig)) + JoinPointHelper.getArgsAsShortString(args);
    }

    public static String getAsLongString(JoinPoint joinpoint) {
        Signature sig = joinpoint.getSignature();
        if (sig instanceof FieldSignature) {
            return JoinPointHelper.getAsString(joinpoint);
        }
        Object[] args = joinpoint.getArgs();
        return String.valueOf(SignatureHelper.getAsString(sig.getDeclaringType().getName(), sig)) + JoinPointHelper.getArgsAsString(args);
    }

    @MayReturnNull
    public static Annotation[][] getParameterAnnotations(JoinPoint joinpoint) {
        Signature sig = joinpoint.getSignature();
        if (sig instanceof MethodSignature) {
            Method method = ((MethodSignature)sig).getMethod();
            if (method == null) {
                return new Annotation[0][0];
            }
            return method.getParameterAnnotations();
        }
        if (sig instanceof ConstructorSignature) {
            ConstructorSignature ctorSig = (ConstructorSignature)sig;
            return JoinPointHelper.getParameterAnnotations(ctorSig);
        }
        return new Annotation[0][0];
    }

    @MayReturnNull
    private static Annotation[][] getParameterAnnotations(ConstructorSignature ctorSig) {
        Constructor ctor = ctorSig.getConstructor();
        Annotation[][] annotations = ctor.getParameterAnnotations();
        if (JoinPointHelper.isInnerClass((Signature)ctorSig)) {
            Annotation[][] corrected = new Annotation[annotations.length + 1][0];
            corrected[0] = null;
            System.arraycopy(annotations, 0, corrected, 1, annotations.length);
            return corrected;
        }
        return annotations;
    }

    @MayReturnNull
    public static Annotation getClassAnnotation(JoinPoint jp, Class<? extends Annotation> annotationClass) {
        Class thisClass = jp.getSignature().getDeclaringType();
        assert (thisClass != null);
        return thisClass.getAnnotation(annotationClass);
    }

    @NullArgsAllowed
    public static String getArgsAsString(Object[] args) {
        if (args == null || args.length == 0) {
            return "()";
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(JoinPointHelper.getArgAsString(args[0]));
        int i = 1;
        while (i < args.length) {
            sb.append(", ");
            sb.append(JoinPointHelper.getArgAsString(args[i]));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    @NullArgsAllowed
    private static String getArgsAsString(Object[] args, Annotation[][] annotations) {
        if (args == null || args.length == 0) {
            return "()";
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(JoinPointHelper.getArgAsString(args[0], annotations[0]));
        int i = 1;
        while (i < args.length) {
            sb.append(", ");
            sb.append(JoinPointHelper.getArgAsString(args[i], annotations[i]));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    @NullArgsAllowed
    public static String getArgsAsShortString(Object[] args) {
        String shortString = JoinPointHelper.getArgsAsString(args);
        if (shortString.length() < 20) {
            return shortString;
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(JoinPointHelper.getArgAsShortString(args[0]));
        int n = args.length;
        if (n > 3) {
            n = 3;
        }
        int i = 1;
        while (i < n) {
            sb.append(", ");
            sb.append(JoinPointHelper.getArgAsShortString(args[i]));
            ++i;
        }
        if (args.length > 3) {
            sb.append(", ..");
        }
        sb.append(")");
        return sb.toString();
    }

    @NullArgsAllowed
    public static String getArgAsString(Object obj) {
        if (obj == null) {
            return "(null)";
        }
        if (obj instanceof String) {
            return "\"" + obj + "\"";
        }
        return obj.toString();
    }

    @NullArgsAllowed
    public static String getArgAsShortString(Object obj) {
        if (obj == null) {
            return "(null)";
        }
        String shortString = Converter.toShortString(obj);
        if (obj instanceof String) {
            return "\"" + shortString + "\"";
        }
        return shortString;
    }

    @NullArgsAllowed
    private static String getArgAsString(Object obj, Annotation[] annotations) {
        if (JoinPointHelper.hasDontLogMeAnnotation(annotations)) {
            return "*";
        }
        return JoinPointHelper.getArgAsString(obj);
    }

    private static boolean hasDontLogMeAnnotation(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof DontLogMe) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isInnerClass(JoinPoint jp) {
        return JoinPointHelper.isInnerClass(jp.getSignature());
    }

    public static boolean isInnerClass(Signature sig) {
        String typeName = sig.getDeclaringTypeName();
        return typeName.contains("$");
    }

    public static Class<?> getCallerClass() {
        return StackTraceScanner.getCallerClass(ADVICE_PATTERNS, JoinPointHelper.class);
    }

    public static Class<?> getCallerClass(Class<?> ... excluded) {
        return StackTraceScanner.getCallerClass(ADVICE_PATTERNS, excluded);
    }

    public static StackTraceElement getCallerOf(JoinPoint jp) {
        return JoinPointHelper.getCallerOf(jp, ADVICE_PATTERNS);
    }

    public static StackTraceElement getCallerOf(JoinPoint jp, Pattern ... excluded) {
        return StackTraceScanner.getCallerOf(jp.getSignature(), excluded);
    }
}

