/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.reflect.ConstructorSignatureImpl;
import patterntesting.runtime.util.reflect.MethodSignatureImpl;

public class SignatureHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureHelper.class);

    private SignatureHelper() {
    }

    public static String getAsString(Signature sig) {
        if (sig instanceof CodeSignature) {
            try {
                CodeSignature codeSig = (CodeSignature)sig;
                String name = SignatureHelper.getAsString(sig.getDeclaringTypeName(), sig);
                Object[] params = codeSig.getParameterTypes();
                return String.valueOf(name) + "(" + Converter.toShortString(params) + ")";
            }
            catch (RuntimeException e) {
                LOG.debug("Cannot get '" + sig + "' as short string:", (Throwable)e);
            }
        }
        return sig.toString();
    }

    public static String getAsString(String type, Signature sig) {
        String name = sig.getName();
        if ("<init>".equals(name)) {
            return "new " + type;
        }
        return String.valueOf(type) + "." + name;
    }

    public static MethodSignature getAsSignature(Method method) {
        return new MethodSignatureImpl(method);
    }

    public static ConstructorSignature getAsSignature(Constructor<?> ctor) {
        return new ConstructorSignatureImpl(ctor);
    }

    public static Signature getAsSignature(String label) throws ReflectiveOperationException {
        if (label.startsWith("new ")) {
            return SignatureHelper.getAsConstructorSignature(label);
        }
        String classDotMethod = StringUtils.substringBefore((String)label, (String)"(");
        String className = StringUtils.substringBeforeLast((String)classDotMethod, (String)".");
        String methodName = StringUtils.substringAfterLast((String)classDotMethod, (String)".");
        Class<?>[] params = SignatureHelper.getParameterTypes(label);
        return SignatureHelper.getAsSignature(Class.forName(className), methodName, params);
    }

    private static Signature getAsSignature(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws ReflectiveOperationException {
        Method method = clazz.getMethod(methodName, parameterTypes);
        return SignatureHelper.getAsSignature(method);
    }

    private static ConstructorSignature getAsConstructorSignature(String label) throws ReflectiveOperationException {
        String ctor = StringUtils.substringAfterLast((String)label, (String)" ").trim();
        String className = StringUtils.substringBefore((String)ctor, (String)"(");
        Class<?>[] params = SignatureHelper.getParameterTypes(label);
        return SignatureHelper.getAsConstructorSignature(Class.forName(className), params);
    }

    private static ConstructorSignature getAsConstructorSignature(Class<?> clazz, Class<?>[] parameterTypes) throws ReflectiveOperationException {
        Constructor<?> ctor = clazz.getConstructor(parameterTypes);
        return SignatureHelper.getAsSignature(ctor);
    }

    private static Class<?>[] getParameterTypes(String label) throws ClassNotFoundException {
        String parameters = StringUtils.substringAfter((String)label, (String)"(");
        parameters = StringUtils.substringBefore((String)parameters, (String)")");
        String[] params = StringUtils.split((String)parameters, (char)',');
        Class[] parameterTypes = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            parameterTypes[i] = Class.forName(params[i].trim());
            ++i;
        }
        return parameterTypes;
    }

    public static boolean hasReturnType(Signature signature) {
        MethodSignature methodSignature;
        return signature instanceof MethodSignature && (methodSignature = (MethodSignature)signature).getReturnType() != Void.TYPE;
    }
}

