/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.exception.NotFoundException;
import patterntesting.runtime.util.Converter;

public final class StackTraceScanner {
    private static final Logger LOG = LoggerFactory.getLogger(StackTraceScanner.class);

    private StackTraceScanner() {
    }

    public static StackTraceElement findConstructor(Class<?> clazz) {
        return StackTraceScanner.find(clazz.getName(), "<init>");
    }

    public static StackTraceElement find(Signature signature) {
        if (signature instanceof MethodSignature) {
            return StackTraceScanner.find((MethodSignature)signature);
        }
        if (signature instanceof ConstructorSignature) {
            return StackTraceScanner.find((ConstructorSignature)signature);
        }
        throw new IllegalArgumentException(signature + " is not a method or ctor signature");
    }

    private static StackTraceElement find(ConstructorSignature signature) {
        return StackTraceScanner.findConstructor(signature.getDeclaringType());
    }

    private static StackTraceElement find(MethodSignature signature) {
        return StackTraceScanner.find(signature.getDeclaringType(), signature.getMethod());
    }

    public static StackTraceElement find(Class<?> clazz, Method method) {
        return StackTraceScanner.find(clazz.getName(), method.getName());
    }

    public static StackTraceElement find(Class<?> clazz, String methodName) {
        return StackTraceScanner.find(clazz.getName(), methodName);
    }

    public static StackTraceElement find(String classname, String methodName) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = StackTraceScanner.getIndexOf(classname, methodName, stackTrace);
        return stackTrace[i];
    }

    public static StackTraceElement getCallerOfConstructor(Class<?> clazz) {
        return StackTraceScanner.getCallerOfConstructor(clazz, new Pattern[0]);
    }

    /*
     * Unable to fully structure code
     */
    public static StackTraceElement getCallerOfConstructor(Class<?> clazz, Pattern ... excluded) {
        try {
            return StackTraceScanner.getCallerOf(clazz, "<init>", excluded);
        }
        catch (NotFoundException nfe) {
            StackTraceScanner.LOG.trace("Caller of constructor of {} not found:", clazz, (Object)nfe);
            StackTraceScanner.LOG.debug("Looking for adviced init method because of {}", (Object)nfe.getMessage());
            stackTrace = Thread.currentThread().getStackTrace();
            i = 1;
            ** while (i < stackTrace.length)
        }
lbl-1000:
        // 1 sources

        {
            if (stackTrace[i].getMethodName().startsWith("init$")) {
                j = i + 1;
                while (j < stackTrace.length) {
                    if (!StackTraceScanner.matches(stackTrace[j].getMethodName(), excluded)) {
                        return stackTrace[j];
                    }
                    ++j;
                }
                break;
            }
            ++i;
            continue;
        }
lbl19:
        // 2 sources

        throw new NotFoundException("new " + clazz.getSimpleName() + "(..) not part of " + Converter.toShortString(stackTrace));
    }

    public static StackTraceElement getCallerOf(Signature signature) {
        return StackTraceScanner.getCallerOf(signature, new Pattern[0]);
    }

    public static StackTraceElement getCallerOf(Class<?> clazz, Method method) {
        return StackTraceScanner.getCallerOf(clazz, method, new Pattern[0]);
    }

    public static StackTraceElement getCallerOf(Class<?> clazz, String methodName) {
        return StackTraceScanner.getCallerOf(clazz, methodName, new Pattern[0]);
    }

    public static StackTraceElement getCallerOf(String classname, String methodName) {
        return StackTraceScanner.getCallerOf(classname, methodName, new Pattern[0]);
    }

    public static StackTraceElement getCallerOf(Signature signature, Pattern ... excluded) {
        if (signature instanceof MethodSignature) {
            return StackTraceScanner.getCallerOf((MethodSignature)signature, excluded);
        }
        if (signature instanceof ConstructorSignature) {
            return StackTraceScanner.getCallerOf((ConstructorSignature)signature, excluded);
        }
        throw new IllegalArgumentException(signature + " is not a method or ctor signature");
    }

    private static StackTraceElement getCallerOf(ConstructorSignature signature, Pattern ... excluded) {
        return StackTraceScanner.getCallerOfConstructor(signature.getDeclaringType(), excluded);
    }

    private static StackTraceElement getCallerOf(MethodSignature signature, Pattern ... excluded) {
        return StackTraceScanner.getCallerOf(signature.getDeclaringType(), signature.getMethod(), excluded);
    }

    public static StackTraceElement getCallerOf(Class<?> clazz, Method method, Pattern ... excluded) {
        return StackTraceScanner.getCallerOf(clazz.getName(), method.getName(), excluded);
    }

    public static StackTraceElement getCallerOf(Class<?> clazz, String methodName, Pattern ... excluded) {
        return StackTraceScanner.getCallerOf(clazz.getName(), methodName, excluded);
    }

    public static StackTraceElement getCallerOf(String classname, String methodName, Pattern ... excluded) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = StackTraceScanner.getIndexOf(classname, methodName, stackTrace) + 1;
        while (i < stackTrace.length) {
            if (!StackTraceScanner.matches(stackTrace[i].getMethodName(), excluded)) {
                return stackTrace[i];
            }
            ++i;
        }
        throw new NotFoundException(String.valueOf(classname) + "." + methodName + "()");
    }

    private static int getIndexOf(String classname, String methodName, StackTraceElement[] stackTrace) {
        int i = 1;
        while (i < stackTrace.length) {
            StackTraceElement element = stackTrace[i];
            if (methodName.equals(element.getMethodName()) && classname.equals(element.getClassName())) {
                return i;
            }
            ++i;
        }
        throw new NotFoundException(String.valueOf(classname) + "." + methodName + "()");
    }

    private static boolean matches(String methodName, Pattern ... excluded) {
        int j = 0;
        while (j < excluded.length) {
            if (excluded[j].matcher(methodName).matches()) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private static boolean matches(String className, Class<?> ... excluded) {
        int j = 0;
        while (j < excluded.length) {
            if (className.equals(excluded[j].getName())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static Class<?> getCallerClass() {
        return StackTraceScanner.getCallerClass(new Pattern[0]);
    }

    public static Class<?> getCallerClass(Pattern ... excluded) {
        return StackTraceScanner.getCallerClass(excluded, new Class[0]);
    }

    public static Class<?> getCallerClass(Pattern[] excludedMethods, Class<?> ... excludedClasses) {
        StackTraceElement[] stackTrace = StackTraceScanner.getCallerStackTrace(excludedMethods, excludedClasses);
        String classname = stackTrace[0].getClassName();
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new NotFoundException(classname, ex);
        }
    }

    public static StackTraceElement[] getCallerStackTrace() {
        return StackTraceScanner.getCallerStackTrace(new Pattern[0]);
    }

    public static StackTraceElement[] getCallerStackTrace(Pattern ... excluded) {
        return StackTraceScanner.getCallerStackTrace(excluded, new Class[0]);
    }

    public static StackTraceElement[] getCallerStackTrace(Pattern[] excludedMethods, Class<?> ... excludedClasses) {
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 2;
        String scannerClassName = StackTraceScanner.class.getName();
        while (i < stackTrace.length - 1) {
            if (!scannerClassName.equals(stackTrace[i].getClassName())) break;
            ++i;
        }
        while (i < stackTrace.length - 1) {
            if (!StackTraceScanner.matches(stackTrace[i].getMethodName(), excludedMethods) && !StackTraceScanner.matches(((StackTraceElement)stackTrace[i]).getClassName(), excludedClasses)) break;
            ++i;
        }
        return (StackTraceElement[])ArrayUtils.subarray((Object[])stackTrace, (int)i, (int)stackTrace.length);
    }
}

