/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.util.concurrent.TimeUnit;
import org.aspectj.runtime.internal.AroundClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import patterntesting.runtime.TimeMachineAspect;
import patterntesting.runtime.util.Converter;

public final class ThreadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtil.class);
    private static final long TIME_IN_MILLIS = ThreadUtil.calibrateMillis();

    static {
        LOG.debug("timeInMillis calibrated (" + TIME_IN_MILLIS + "ms)");
    }

    private ThreadUtil() {
    }

    public static void sleep() {
        ThreadUtil.sleep(TIME_IN_MILLIS);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ignored) {
            LOG.info(ignored + " ignored");
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(long millis, int nanos) {
        try {
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException ignored) {
            LOG.info(ignored + " ignored");
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(int time, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                ThreadUtil.sleep(0L, time);
                break;
            }
            case MICROSECONDS: {
                ThreadUtil.sleep(0L, time * 1000);
                break;
            }
            case MILLISECONDS: {
                ThreadUtil.sleep(time);
                break;
            }
            case SECONDS: {
                ThreadUtil.sleep((long)time * 1000L);
                break;
            }
            case MINUTES: {
                ThreadUtil.sleep((long)time * 1000L * 60L);
                break;
            }
            case HOURS: {
                ThreadUtil.sleep((long)time * 1000L * 60L * 60L);
                break;
            }
            case DAYS: {
                ThreadUtil.sleep((long)time * 1000L * 60L * 60L * 24L);
                break;
            }
            default: {
                LOG.warn("unknown TimeUnit " + (Object)((Object)unit) + " interpreting it as WEEKS");
                ThreadUtil.sleep((long)time * 1000L * 60L * 60L * 24L * 7L);
            }
        }
    }

    private static long calibrateMillis() {
        long t0 = ThreadUtil.nextTimeMillis();
        long t1 = ThreadUtil.nextTimeMillis();
        return t1 - t0;
    }

    private static long nextTimeMillis() {
        long l;
        long t0 = TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ThreadUtil.currentTimeMillis_aroundBody1$advice(TimeMachineAspect.aspectOf(), null) : ThreadUtil.currentTimeMillis_aroundBody0();
        do {
            if (TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid()) {
                l = ThreadUtil.currentTimeMillis_aroundBody3$advice(TimeMachineAspect.aspectOf(), null);
                continue;
            }
            l = ThreadUtil.currentTimeMillis_aroundBody2();
        } while (t0 == l);
        return TimeMachineAspect.ajc$cflowCounter$0.isValid() || TimeMachineAspect.ajc$cflowCounter$1.isValid() ? ThreadUtil.currentTimeMillis_aroundBody5$advice(TimeMachineAspect.aspectOf(), null) : ThreadUtil.currentTimeMillis_aroundBody4();
    }

    public static long getTimerResolutionInMillis() {
        return TIME_IN_MILLIS;
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody0() {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody1$advice(TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody2() {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody3$advice(TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody4() {
        return System.currentTimeMillis();
    }

    private static final /* synthetic */ long currentTimeMillis_aroundBody5$advice(TimeMachineAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure) {
        return Converter.toDate(TimeMachineAspect.ajc$inlineAccessFieldGet$patterntesting_runtime_TimeMachineAspect$patterntesting_runtime_TimeMachineAspect$timeMachine(ajc$aspectInstance).today()).getTime();
    }
}

