/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalIpV6NeighborDiscoveryOption;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6NeighborDiscoveryMtuOption;
import org.pcap4j.packet.IpV6NeighborDiscoveryPrefixInformationOption;
import org.pcap4j.packet.IpV6NeighborDiscoveryRedirectedHeaderOption;
import org.pcap4j.packet.IpV6NeighborDiscoverySourceLinkLayerAddressOption;
import org.pcap4j.packet.IpV6NeighborDiscoveryTargetLinkLayerAddressOption;
import org.pcap4j.packet.UnknownIpV6NeighborDiscoveryOption;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;

public final class StaticIpV6NeighborDiscoveryOptionFactory
implements PacketFactory<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption, IpV6NeighborDiscoveryOptionType> {
    private static final StaticIpV6NeighborDiscoveryOptionFactory INSTANCE = new StaticIpV6NeighborDiscoveryOptionFactory();
    private final Map<IpV6NeighborDiscoveryOptionType, Instantiater> instantiaters = new HashMap<IpV6NeighborDiscoveryOptionType, Instantiater>();

    private StaticIpV6NeighborDiscoveryOptionFactory() {
        this.instantiaters.put(IpV6NeighborDiscoveryOptionType.SOURCE_LINK_LAYER_ADDRESS, new Instantiater(){

            @Override
            public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6NeighborDiscoverySourceLinkLayerAddressOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6NeighborDiscoverySourceLinkLayerAddressOption> getTargetClass() {
                return IpV6NeighborDiscoverySourceLinkLayerAddressOption.class;
            }
        });
        this.instantiaters.put(IpV6NeighborDiscoveryOptionType.TARGET_LINK_LAYER_ADDRESS, new Instantiater(){

            @Override
            public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6NeighborDiscoveryTargetLinkLayerAddressOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6NeighborDiscoveryTargetLinkLayerAddressOption> getTargetClass() {
                return IpV6NeighborDiscoveryTargetLinkLayerAddressOption.class;
            }
        });
        this.instantiaters.put(IpV6NeighborDiscoveryOptionType.PREFIX_INFORMATION, new Instantiater(){

            @Override
            public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6NeighborDiscoveryPrefixInformationOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6NeighborDiscoveryPrefixInformationOption> getTargetClass() {
                return IpV6NeighborDiscoveryPrefixInformationOption.class;
            }
        });
        this.instantiaters.put(IpV6NeighborDiscoveryOptionType.REDIRECTED_HEADER, new Instantiater(){

            @Override
            public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6NeighborDiscoveryRedirectedHeaderOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6NeighborDiscoveryRedirectedHeaderOption> getTargetClass() {
                return IpV6NeighborDiscoveryRedirectedHeaderOption.class;
            }
        });
        this.instantiaters.put(IpV6NeighborDiscoveryOptionType.MTU, new Instantiater(){

            @Override
            public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6NeighborDiscoveryMtuOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6NeighborDiscoveryMtuOption> getTargetClass() {
                return IpV6NeighborDiscoveryMtuOption.class;
            }
        });
    }

    public static StaticIpV6NeighborDiscoveryOptionFactory getInstance() {
        return INSTANCE;
    }

    public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length, IpV6NeighborDiscoveryOptionType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData, offset, length);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6NeighborDiscoveryOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        return this.newInstance(rawData, offset, length);
    }

    public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) {
        try {
            return UnknownIpV6NeighborDiscoveryOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6NeighborDiscoveryOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
    }

    public Class<? extends IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getTargetClass(IpV6NeighborDiscoveryOptionType number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        Instantiater instantiater = this.instantiaters.get(number);
        return instantiater != null ? instantiater.getTargetClass() : this.getTargetClass();
    }

    public Class<? extends IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getTargetClass() {
        return UnknownIpV6NeighborDiscoveryOption.class;
    }

    private static interface Instantiater {
        public IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newInstance(byte[] var1, int var2, int var3) throws IllegalRawDataException;

        public Class<? extends IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getTargetClass();
    }
}

