/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SnapPacket;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.LlcNumber;

public final class StaticLlcNumberPacketFactory
extends AbstractStaticPacketFactory<LlcNumber> {
    private static final StaticLlcNumberPacketFactory INSTANCE = new StaticLlcNumberPacketFactory();

    private StaticLlcNumberPacketFactory() {
        this.instantiaters.put(LlcNumber.ARP, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<ArpPacket> getTargetClass() {
                return ArpPacket.class;
            }
        });
        this.instantiaters.put(LlcNumber.SNAP, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return SnapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<SnapPacket> getTargetClass() {
                return SnapPacket.class;
            }
        });
    }

    public static StaticLlcNumberPacketFactory getInstance() {
        return INSTANCE;
    }
}

