/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.BsdLoopbackPacket;
import org.pcap4j.packet.Dot11Selector;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.HdlcPppPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpSelector;
import org.pcap4j.packet.LinuxSllPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PppSelector;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.DataLinkType;

public final class StaticDataLinkTypePacketFactory
extends AbstractStaticPacketFactory<DataLinkType> {
    private static final StaticDataLinkTypePacketFactory INSTANCE = new StaticDataLinkTypePacketFactory();

    private StaticDataLinkTypePacketFactory() {
        this.instantiaters.put(DataLinkType.EN10MB, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return EthernetPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<EthernetPacket> getTargetClass() {
                return EthernetPacket.class;
            }
        });
        this.instantiaters.put(DataLinkType.PPP, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return PppSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<PppSelector> getTargetClass() {
                return PppSelector.class;
            }
        });
        this.instantiaters.put(DataLinkType.RAW, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpSelector> getTargetClass() {
                return IpSelector.class;
            }
        });
        this.instantiaters.put(DataLinkType.PPP_SERIAL, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return HdlcPppPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<HdlcPppPacket> getTargetClass() {
                return HdlcPppPacket.class;
            }
        });
        this.instantiaters.put(DataLinkType.IEEE802_11, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return Dot11Selector.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<Dot11Selector> getTargetClass() {
                return Dot11Selector.class;
            }
        });
        this.instantiaters.put(DataLinkType.LINUX_SLL, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return LinuxSllPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<LinuxSllPacket> getTargetClass() {
                return LinuxSllPacket.class;
            }
        });
        this.instantiaters.put(DataLinkType.IEEE802_11_RADIO, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return RadiotapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<RadiotapPacket> getTargetClass() {
                return RadiotapPacket.class;
            }
        });
        this.instantiaters.put(DataLinkType.NULL, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return BsdLoopbackPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<BsdLoopbackPacket> getTargetClass() {
                return BsdLoopbackPacket.class;
            }
        });
    }

    public static StaticDataLinkTypePacketFactory getInstance() {
        return INSTANCE;
    }
}

