/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.StaticDataLinkTypePacketFactory;
import org.pcap4j.packet.factory.StaticDnsRDataFactory;
import org.pcap4j.packet.factory.StaticDot11FrameTypePacketFactory;
import org.pcap4j.packet.factory.StaticEtherTypePacketFactory;
import org.pcap4j.packet.factory.StaticIcmpV4TypePacketFactory;
import org.pcap4j.packet.factory.StaticIcmpV6TypePacketFactory;
import org.pcap4j.packet.factory.StaticIpNumberPacketFactory;
import org.pcap4j.packet.factory.StaticIpV4InternetTimestampOptionDataFactory;
import org.pcap4j.packet.factory.StaticIpV4OptionFactory;
import org.pcap4j.packet.factory.StaticIpV4TosFactory;
import org.pcap4j.packet.factory.StaticIpV6FlowLabelFactory;
import org.pcap4j.packet.factory.StaticIpV6NeighborDiscoveryOptionFactory;
import org.pcap4j.packet.factory.StaticIpV6OptionFactory;
import org.pcap4j.packet.factory.StaticIpV6RoutingDataFactory;
import org.pcap4j.packet.factory.StaticIpV6TrafficClassFactory;
import org.pcap4j.packet.factory.StaticLlcNumberPacketFactory;
import org.pcap4j.packet.factory.StaticNotApplicablePacketFactory;
import org.pcap4j.packet.factory.StaticPppDllProtocolPacketFactory;
import org.pcap4j.packet.factory.StaticProtocolFamilyPacketFactory;
import org.pcap4j.packet.factory.StaticRadiotapDataFieldFactory;
import org.pcap4j.packet.factory.StaticSctpChunkFactory;
import org.pcap4j.packet.factory.StaticSctpPortPacketFactory;
import org.pcap4j.packet.factory.StaticTcpOptionFactory;
import org.pcap4j.packet.factory.StaticTcpPortPacketFactory;
import org.pcap4j.packet.factory.StaticUdpPortPacketFactory;
import org.pcap4j.packet.factory.StaticUnknownPacketFactory;
import org.pcap4j.packet.namednumber.NamedNumber;

final class PacketFactoryBinder {
    private static final PacketFactoryBinder INSTANCE = new PacketFactoryBinder();

    private PacketFactoryBinder() {
    }

    public static PacketFactoryBinder getInstance() {
        return INSTANCE;
    }

    public <T, N extends NamedNumber<?, ?>> PacketFactory<T, N> getPacketFactory(Class<T> targetClass, Class<N> numberClass) {
        switch (targetClass.getName()) {
            case "org.pcap4j.packet.Packet": {
                switch (numberClass.getName()) {
                    case "org.pcap4j.packet.namednumber.DataLinkType": {
                        return StaticDataLinkTypePacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.EtherType": {
                        return StaticEtherTypePacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.LlcNumber": {
                        return StaticLlcNumberPacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.IcmpV4Type": {
                        return StaticIcmpV4TypePacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.IcmpV6Type": {
                        return StaticIcmpV6TypePacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.IpNumber": {
                        return StaticIpNumberPacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.TcpPort": {
                        return StaticTcpPortPacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.UdpPort": {
                        return StaticUdpPortPacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.SctpPort": {
                        return StaticSctpPortPacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.NotApplicable": {
                        return StaticNotApplicablePacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.PppDllProtocol": {
                        return StaticPppDllProtocolPacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.ProtocolFamily": {
                        return StaticProtocolFamilyPacketFactory.getInstance();
                    }
                    case "org.pcap4j.packet.namednumber.Dot11FrameType": {
                        return StaticDot11FrameTypePacketFactory.getInstance();
                    }
                }
                return StaticUnknownPacketFactory.getInstance();
            }
            case "org.pcap4j.packet.IpV4Packet$IpV4Option": {
                return StaticIpV4OptionFactory.getInstance();
            }
            case "org.pcap4j.packet.IpV4InternetTimestampOption": {
                return StaticIpV4InternetTimestampOptionDataFactory.getInstance();
            }
            case "org.pcap4j.packet.TcpPacket$TcpOption": {
                return StaticTcpOptionFactory.getInstance();
            }
            case "org.pcap4j.packet.IpV6ExtOptionsPacket$IpV6Option": {
                return StaticIpV6OptionFactory.getInstance();
            }
            case "org.pcap4j.packet.IpV6ExtRoutingPacket$IpV6RoutingData": {
                return StaticIpV6RoutingDataFactory.getInstance();
            }
            case "org.pcap4j.packet.IcmpV6CommonPacket$IpV6NeighborDiscoveryOption": {
                return StaticIpV6NeighborDiscoveryOptionFactory.getInstance();
            }
            case "org.pcap4j.packet.IpV4Packet$IpV4Tos": {
                return StaticIpV4TosFactory.getInstance();
            }
            case "org.pcap4j.packet.IpV6Packet$IpV6TrafficClass": {
                return StaticIpV6TrafficClassFactory.getInstance();
            }
            case "org.pcap4j.packet.IpV6Packet$IpV6FlowLabel": {
                return StaticIpV6FlowLabelFactory.getInstance();
            }
            case "org.pcap4j.packet.RadiotapPacket$RadiotapData": {
                return StaticRadiotapDataFieldFactory.getInstance();
            }
            case "org.pcap4j.packet.SctpPacket$SctpChunk": {
                return StaticSctpChunkFactory.getInstance();
            }
            case "org.pcap4j.packet.DnsResourceRecord$DnsRData": {
                return StaticDnsRDataFactory.getInstance();
            }
        }
        throw new IllegalStateException("Unsupported target: " + targetClass);
    }
}

