/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.DnsPacket;
import org.pcap4j.packet.GtpSelector;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.UdpPort;

public final class StaticUdpPortPacketFactory
implements PacketFactory<Packet, UdpPort> {
    private static final StaticUdpPortPacketFactory INSTANCE = new StaticUdpPortPacketFactory();

    private StaticUdpPortPacketFactory() {
    }

    public static StaticUdpPortPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, UdpPort number) {
        try {
            switch (Short.toUnsignedInt((Short)number.value())) {
                case 53: {
                    return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2123: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2152: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 3386: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, UdpPort number1, UdpPort number2) {
        try {
            switch (Short.toUnsignedInt((Short)number1.value())) {
                case 53: {
                    return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2123: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2152: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 3386: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch (Short.toUnsignedInt((Short)number2.value())) {
                case 53: {
                    return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2123: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2152: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 3386: {
                    return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, UdpPort ... numbers) {
        try {
            for (UdpPort num : numbers) {
                switch (Short.toUnsignedInt((Short)num.value())) {
                    case 53: {
                        return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 2123: {
                        return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 2152: {
                        return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 3386: {
                        return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

