/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SnapPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.LlcNumber;

public final class StaticLlcNumberPacketFactory
implements PacketFactory<Packet, LlcNumber> {
    private static final StaticLlcNumberPacketFactory INSTANCE = new StaticLlcNumberPacketFactory();

    private StaticLlcNumberPacketFactory() {
    }

    public static StaticLlcNumberPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, LlcNumber number) {
        try {
            switch ((Byte)number.value() & 0xFF) {
                case 152: {
                    return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 170: {
                    return SnapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, LlcNumber number1, LlcNumber number2) {
        try {
            switch ((Byte)number1.value() & 0xFF) {
                case 152: {
                    return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 170: {
                    return SnapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch ((Byte)number2.value() & 0xFF) {
                case 152: {
                    return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 170: {
                    return SnapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, LlcNumber ... numbers) {
        try {
            for (LlcNumber num : numbers) {
                switch ((Byte)num.value() & 0xFF) {
                    case 152: {
                        return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 170: {
                        return SnapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

