/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.PppDllProtocol;

public final class StaticPppDllProtocolPacketFactory
implements PacketFactory<Packet, PppDllProtocol> {
    private static final StaticPppDllProtocolPacketFactory INSTANCE = new StaticPppDllProtocolPacketFactory();

    private StaticPppDllProtocolPacketFactory() {
    }

    public static StaticPppDllProtocolPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, PppDllProtocol number) {
        try {
            switch ((Short)number.value() & 0xFFFF) {
                case 33: {
                    return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 87: {
                    return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, PppDllProtocol number1, PppDllProtocol number2) {
        try {
            switch ((Short)number1.value() & 0xFFFF) {
                case 33: {
                    return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 87: {
                    return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch ((Short)number2.value() & 0xFFFF) {
                case 33: {
                    return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 87: {
                    return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, PppDllProtocol ... numbers) {
        try {
            for (PppDllProtocol num : numbers) {
                switch ((Short)num.value() & 0xFFFF) {
                    case 33: {
                        return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 87: {
                        return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

